<instrumentationManifest xsi:schemaLocation="http://schemas.microsoft.com/win/2004/08/events eventman.xsd" xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:trace="http://schemas.microsoft.com/win/2004/08/events/trace" xmlns="http://schemas.microsoft.com/win/2004/08/events">

	<!-- ETW Instrumentation Manifest for AirSpace -->
	<!-- 
	The events described in this manifest are built into a generated
	header file by manpp.exe. The generated header file contains
	macros that allow a provider to be registered and unregistered.
	In addition there are macros for writing each event.

	The generated header file is actually checked into office source
	so that things like offsos and source server will work. To ensure 
	that the checked in header doesn't get out of sync with the manifest 
	the header is generated again at build time. If the built header 
	doesn't match the checked in header the build will fail.

	This ETW manifest is also used by test automation and tools,
	so changing existing definitions of events, opcodes, templates,
	etc. will cause build breaks. The events are compiled d
	a .cs file which are used by such projects as:

		airspace/tools/etwmon, airspacetasklib, perfcore, uextest, timber, mso/msoimm2, msodll_99, devappx_airbud ...

	********************************************************************
	It is HIGHLY RECOMMENDED you do not change pre-existing event
	definitions, names, opcodes, templates, etc. in order to avoid build
	breaks.  In the new daily build system, the changes will be backed
	out if main gets broken.
	********************************************************************

	Here's what you need to do whenever you change this manifest file:

	1. Run this command to update all auto-generated code that's
		 based on this manifest (e.g., C++ headers, C# parsers):

					updateetw airspace

	2. Build the most obviously affected projects (when in doubt, ask Test):

					ohome build airspace airspacetasklib perfcore uextest timber devappx_airbud mso msodll_40ui

	3. Add an event consumer to %AIRSPACE%\tools\etwmon\etwmon\program.cs
		 This will act as a canary against later build breaks.  If this
		 breaks, then it is pretty certain something else will.  However,
		 this only works if new events are added.

-->

	<instrumentation>
		<events>
			<provider name="OfficeAirSpace" guid="{f562bb8e-422d-4b5c-b20e-90d710f7d11c}" symbol="guidProviderOfficeAirSpace" resourceFileName="airbud.exe" messageFileName="airbud.exe" message="$(string.OfficeAirSpaceProviderName)">
				<events>
					<event symbol="AutomationIdEtw"                                                              value="3"   version="2" channel="CHANNEL_AIRSPACE" level="win:Verbose"       task="Channel"                                 opcode="win:Info"                                       keywords="Automation"                            template="tidAutomationId"                                                                 />
					<event symbol="DxDeviceCreatedEtw"                                                           value="4"   version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectX"                                 opcode="win:Info"                                       keywords="DirectX"                               template="tidDeviceCreation"                                                               />
					<event symbol="SceneInitializeStartEtw"                                                      value="5"   version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Start"                                      keywords="Initialization"                        />
					<event symbol="SceneInitializeEndEtw"                                                        value="6"   version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Stop"                                       keywords="Initialization"                        />
					<event symbol="SceneInitializeFailedEtw"                                                     value="7"   version="2" channel="CHANNEL_AIRSPACE" level="win:Critical"      task="Channel"                                 opcode="win:Info"                                       keywords="Initialization"                        />
					<event symbol="CompositorInitializeStartEtw"                                                 value="8"   version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Start"                                      keywords="Initialization"                        />
					<event symbol="CompositorInitializeEndEtw"                                                   value="9"   version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Stop"                                       keywords="Initialization"                        />
					<event symbol="CompositorInitializeFailedEtw"                                                value="10"  version="2" channel="CHANNEL_AIRSPACE" level="win:Critical"      task="Compositor"                              opcode="win:Info"                                       keywords="Initialization"                        />
					<event symbol="DxTextureCreatedEtw"                                                          value="11"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectX"                                 opcode="win:Info"                                       keywords="DirectX Texture"                       template="tidTextureCreate"                                                                />
					<event symbol="DxErrorEtw"                                                                   value="16"  version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="DirectX"                                 opcode="win:Info"                                       keywords="DirectX"                               template="tidDxError"                                                                      />
					<event symbol="StdExceptionErrorEtw"                                                         value="22"  version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="Compositor"                              opcode="win:Info"                                       keywords="Exception"                             />
					<event symbol="StdExceptionCriticalEtw"                                                      value="23"  version="2" channel="CHANNEL_AIRSPACE" level="win:Critical"      task="Compositor"                              opcode="win:Info"                                       keywords="Exception"                             />
					<event symbol="SceneShutdownStartEtw"                                                        value="26"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Start"                                      keywords="Shutdown"                              />
					<event symbol="SceneShutdownEndEtw"                                                          value="27"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Stop"                                       keywords="Shutdown"                              />
					<event symbol="CompositorShutdownStartEtw"                                                   value="28"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Start"                                      keywords="Shutdown"                              />
					<event symbol="CompositorShutdownEndEtw"                                                     value="29"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Stop"                                       keywords="Shutdown"                              />
					<event symbol="LayerFlattenedEtw"                                                            value="30"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Layer"                                 template="tidHandle"                                                                       />
					<event symbol="StoryboardScheduled"                                                          value="31"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidStoryboard"                                                                   />
					<event symbol="KeyframeScheduled"                                                            value="32"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidKeyframe"                                                                     />
					<event symbol="LayerUpdate"                                                                  value="33"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidLayerUpdate"                                                                  />
					<event symbol="StoryboardComplete"                                                           value="34"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidStoryboardComplete"                                                           />
					<event symbol="AirSpyMetricsEtw"                                                             value="35"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="AirSpy"                                  opcode="win:Info"                                       keywords="AirSpy"                                template="tidAirSpyMetrics"                                                                />
					<event symbol="AtlasCompactionEtw"                                                           value="36"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Atlas"                                 />
					<event symbol="DxTextureDestroyedEtw"                                                        value="37"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectX"                                 opcode="win:Info"                                       keywords="DirectX Texture"                       template="tidTextureCreate"                                                                />
					<event symbol="AnimationPropertyTarget"                                                      value="38"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidAnimationPropertyTarget"                                                      />
					<event symbol="CompositorFrame"                                                              value="39"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Timing"                                template="tidCompositorFrame"                                                              />
					<event symbol="RenderFrame"                                                                  value="40"  version="1" channel="CHANNEL_AIRSPACE" level="win:Informational" task="RenderThread"                            opcode="RenderFrame"                                    keywords="Timing"                                template="tidRenderFrame"                                                                  />
					<event symbol="CanvasFrame"                                                                  value="41"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="RenderThread"                            opcode="win:Info"                                       keywords="Timing"                                template="tidCanvasFrame"                                                                  />
					<event symbol="DeviceModeEtw"                                                                value="42"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="CPU GPU"                               template="tidDeviceChange"                                                                 />
					<event symbol="AnimationsEnvironmentChangeEtw"                                               value="43"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationsEnvironmentChange"                                                  />
					<event symbol="SceneIdleCheckerStartEtw"                                                     value="44"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Info"                                       keywords="LowResourceMode"                       />
					<event symbol="RenderTargetEnterLowResourceMode"                                             value="46"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Start"                                      keywords="LowResourceMode"                       template="tidHwnd"                                                                         />
					<event symbol="RenderTargetLeaveLowResourceMode"                                             value="47"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Stop"                                       keywords="LowResourceMode"                       template="tidHwnd"                                                                         />
					<event symbol="LayerHostStartingRecoveryFromLowResourceMode"                                 value="48"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="LayerHostStartingRecoveryFromLowResourceMode"   keywords="LowResourceMode"                       template="tidHandleHwnd"                                                                   />
					<event symbol="LayerHostFinishedRecoveryFromLowResourceMode"                                 value="49"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="LayerHostFinishedRecoveryFromLowResourceMode"   keywords="LowResourceMode"                       template="tidHandleHwnd"                                                                   />
					<event symbol="GdiRenderTargetPresented"                                                     value="50"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="RenderThread"                            opcode="win:Info"                                       keywords="CPU GDIRendering"                      template="tidGdiRenderTargetPresentInfo"                                                   />
					<event symbol="CommandQueued"                                                                value="51"  version="1" channel="CHANNEL_AIRSPACE" level="win:Verbose"       task="Channel"                                 opcode="CommandQueued"                                  keywords="Channel"                               template="tidCommandQueued"                                                                />
					<event symbol="SceneBatch"                                                                   value="52"  version="1" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="SceneBatch"                                     keywords="Channel"                               template="tidSceneBatch"                                                                   />
					<event symbol="RenderFrameStats"                                                             value="53"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="RenderThread"                            opcode="win:Info"                                       keywords="Timing"                                template="tidRenderFrameStats"                                                             />
					<event symbol="CompositorTrim"                                                               value="54"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Memory"                                />
					<event symbol="UpdateTextures"                                                               value="55"  version="1" channel="CHANNEL_AIRSPACE" level="win:Informational" task="UpdateTextures"                          opcode="UpdateTextures"                                 keywords="Texture"                               template="tidUpdateTextures"                                                               />
					<event symbol="BatchPresented"                                                               value="56"  version="1" channel="CHANNEL_AIRSPACE" level="win:Informational" task="RenderThread"                            opcode="BatchPresented"                                 keywords="Channel Timing"                        template="tidBatchPresented"                                                               />
					<event symbol="DxDeviceCreationBeginEtw"                                                     value="57"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Start"                                      keywords="DirectX"                               />
					<event symbol="DxDeviceCreationEndEtw"                                                       value="58"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Stop"                                       keywords="DirectX"                               />
					<event symbol="BeginDrawReturnedNullRenderTarget"                                            value="59"  version="2" channel="CHANNEL_AIRSPACE" level="win:Warning"       task="DirectX"                                 opcode="win:Info"                                       keywords="DirectX"                               template="tidBeginDrawReturnedNullRenderTarget"                                            />
					<event symbol="LayerHostEnterLowResourceMode"                                                value="60"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectX"                                 opcode="LayerHostEnterLowResourceMode"                  keywords="LowResourceMode"                       template="tidHandleHwnd"                                                                   />
					<event symbol="DxDeviceDroppedLowResourceMode"                                               value="61"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectX"                                 opcode="win:Info"                                       keywords="LowResourceMode"                       template="tidDevice"                                                                       />
					<event symbol="LayerHostPartiallyRecoveredFromLowResourceMode"                               value="62"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="LayerHostPartiallyRecoveredFromLowResourceMode" keywords="LowResourceMode"                       template="tidHandleHwnd"                                                                   />
					<event symbol="DxAppDeviceResetEtw"                                                          value="63"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="DirectX"                               template="tidAddDeviceReset"                                                               />
					<event symbol="RenderFrameSkippedVBlank"                                                     value="64"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="RenderThread"                            opcode="win:Info"                                       keywords="Timing"                                />
					<event symbol="RenderThreadBeginIdle"                                                        value="65"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="RenderThread"                            opcode="win:Start"                                      keywords="Timing"                                />
					<event symbol="RenderThreadEndIdle"                                                          value="66"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="RenderThread"                            opcode="win:Stop"                                       keywords="Timing"                                />
					<event symbol="LayerHostCanvasRegistered"                                                    value="67"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Initialization"                        template="tidHandle"                                                                       />
					<event symbol="LayerHostCanvasClaimed"                                                       value="68"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Info"                                       keywords="Initialization"                        template="tidHandle"                                                                       />
					<event symbol="OrphanBackendCanvasCount"                                                     value="69"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Initialization"                        template="tidControlCount"                                                                 />
					<event symbol="XamlControlRegistered"                                                        value="70"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Initialization"                        template="tidHandle"                                                                       />
					<event symbol="XamlControlClaimed"                                                           value="71"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Channel"                                 opcode="win:Info"                                       keywords="Initialization"                        template="tidHandle"                                                                       />
					<event symbol="OrphanBackendXamlControlCount"                                                value="72"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Initialization"                        template="tidControlCount"                                                                 />
					<event symbol="XamlLayerInitializeStartEtw"                                                  value="73"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Start"                                      keywords="Initialization"                        template="tidHandle"                                                                       />
					<event symbol="XamlLayerInitializeEndEtw"                                                    value="74"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Stop"                                       keywords="Initialization"                        template="tidHandle"                                                                       />
					<event symbol="DebugLogEtw"                                                                  value="75"  version="2" channel="CHANNEL_AIRSPACE" level="win:Verbose"       task="Compositor"                              opcode="win:Info"                                       keywords="DebugLog"                              template="tidDebugLog"                                                                     />
					<event symbol="XamlDrawableSurfaceEndDrawStop"                                               value="78"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceEndDrawStop"                                               message="$(string.XamlDrawableSurface.EndDraw.Stop)"                                               />
					<event symbol="XamlVirtualSurfaceInvalidateRectInfo"                                         value="79"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualSurface"                      opcode="win:Info"                                       keywords="Texture"                               template="tidXamlVirtualSurfaceInvalidateRectInfo"                                         message="$(string.XamlVirtualSurface.InvalidateRect.Info)"                                         />
					<event symbol="ScrollingLayerSetConfigurationInfo"                                           value="80"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerSetConfigurationInfo"                                           message="$(string.ScrollingLayer.SetConfiguration.Info)"                                           />
					<event symbol="CommandListCompositeSubtractRegionInfo"                                       value="81"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeSubtractRegionInfo"                                       message="$(string.CommandListComposite.SubtractRegion.Info)"                                       />
					<event symbol="XamlVirtualSurfaceUpdateRegionStop"                                           value="82"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualSurfaceUpdateRegionStop"                                           message="$(string.XamlVirtualizedSurface.UpdateRegion.Stop)"                                       />
					<event symbol="VirtualTextureFrontEndImmBeginDrawDirect2dStart"                              value="83"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Start"                                      keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmBeginDrawDirect2dStart"                              message="$(string.VirtualTexture.FrontEndImmBeginDrawDirect2d.Start)"                              />
					<event symbol="VirtualTextureFrontEndImmEndDrawSurfaceInfo"                                  value="84"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmEndDrawSurfaceInfo"                                  message="$(string.VirtualTexture.FrontEndImmEndDrawSurface.Info)"                                  />
					<event symbol="VirtualTextureFrontEndImmBeginDrawDirect2dStop"                               value="85"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Stop"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmBeginDrawDirect2dStop"                               message="$(string.VirtualTexture.FrontEndImmBeginDrawDirect2d.Stop)"                               />
					<event symbol="VirtualTextureFrontEndImmEndDrawCommandListInfo"                              value="86"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture CommandList"          template="tidVirtualTextureFrontEndImmEndDrawCommandListInfo"                              message="$(string.VirtualTexture.FrontEndImmEndDrawCommandList.Info)"                              />
					<event symbol="CommandListCompositeRequestRectInfo"                                          value="87"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeRequestRectInfo"                                          message="$(string.CommandListComposite.RequestRect.Info)"                                          />
					<event symbol="ScrollingLayerSetCanvasSizeInfo"                                              value="88"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerSetCanvasSizeInfo"                                              message="$(string.ScrollingLayer.SetCanvasSize.Info)"                                              />
					<event symbol="XamlVirtualSurfaceUpdateRegionStart"                                          value="89"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlVirtualSurfaceUpdateRegionStart"                                          message="$(string.XamlVirtualizedSurface.UpdateRegion.Start)"                                      />
					<event symbol="CommandListCompositeSubtractInfo"                                             value="90"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeSubtractInfo"                                             message="$(string.CommandListComposite.Subtract.Info)"                                             />
					<event symbol="XamlDrawableSurfaceBeginDrawDirect2dStop"                                     value="91"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceBeginDrawDirect2dStop"                                     message="$(string.XamlDrawableSurface.BeginDrawDirect2d.Stop)"                                     />
					<event symbol="CommandListCompositeAddStop"                                                  value="92"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Stop"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeAddStop"                                                  message="$(string.CommandListComposite.Add.Stop)"                                                  />
					<event symbol="PrefetchScopeMovedStop"                                                       value="93"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="PrefetchScope"                           opcode="win:Stop"                                       keywords="BackEnd"                               template="tidPrefetchScopeMovedStop"                                                       message="$(string.PrefetchScope.Moved.Stop)"                                                       />
					<event symbol="VirtualTextureFrontEndImmBeginDrawSurfaceInfo"                                value="94"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmBeginDrawSurfaceInfo"                                message="$(string.VirtualTexture.FrontEndImmBeginDrawSurface.Info)"                                />
					<event symbol="XamlVirtualSurfaceOnUpdatesNeededInfo"                                        value="95"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualSurfaceOnUpdatesNeededInfo"                                        message="$(string.XamlVirtualizedSurface.OnUpdatesNeeded.Info)"                                    />
					<event symbol="VirtualTextureFrontEndImmEndDrawStop"                                         value="96"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Stop"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmEndDrawStop"                                         message="$(string.VirtualTexture.FrontEndImmEndDraw.Stop)"                                         />
					<event symbol="VirtualTextureFrontEndImmInvalidateRectInfo"                                  value="97"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmInvalidateRectInfo"                                  message="$(string.VirtualTexture.FrontEndImmInvalidateRect.Info)"                                  />
					<event symbol="CommandListCompositeResizeInfo"                                               value="98"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeResizeInfo"                                               message="$(string.CommandListComposite.Resize.Info)"                                               />
					<event symbol="VirtualTextureFrontEndImmEndDrawStart"                                        value="99"  version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Start"                                      keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmEndDrawStart"                                        message="$(string.VirtualTexture.FrontEndImmEndDraw.Start)"                                        />
					<event symbol="XamlDrawableSurfaceEndDrawStart"                                              value="100" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceEndDrawStart"                                              message="$(string.XamlDrawableSurface.EndDraw.Start)"                                              />
					<event symbol="CommandListCompositeAddStart"                                                 value="101" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Start"                                      keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeAddStart"                                                 message="$(string.CommandListComposite.Add.Start)"                                                 />
					<event symbol="XamlVirtualSurfaceUpdateRegionRectInfo"                                       value="102" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualSurfaceUpdateRegionRectInfo"                                       message="$(string.XamlVirtualizedSurface.UpdateRegionRect.Info)"                                   />
					<event symbol="PrefetchScopeMovedStart"                                                      value="103" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="PrefetchScope"                           opcode="win:Start"                                      keywords="BackEnd"                               template="tidPrefetchScopeMovedStart"                                                      message="$(string.PrefetchScope.Moved.Start)"                                                      />
					<event symbol="XamlDrawableSurfaceBeginDrawDirect2dStart"                                    value="104" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceBeginDrawDirect2dStart"                                    message="$(string.XamlDrawableSurface.BeginDrawDirect2d.Start)"                                    />
					<event symbol="XamlVirtualSurfaceResizeInfo"                                                 value="105" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualSurface"                      opcode="win:Info"                                       keywords="Texture"                               template="tidXamlVirtualSurfaceResizeInfo"                                                 message="$(string.XamlVirtualSurface.Resize.Info)"                                                 />
					<event symbol="CommandListDrawInfo"                                                          value="106" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandList"                             opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListDrawInfo"                                                          message="$(string.CommandList.Draw.Info)"                                                          />
					<event symbol="VirtualTextureFrontEndImmBeginDrawCommandListInfo"                            value="107" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmBeginDrawCommandListInfo"                            message="$(string.VirtualTexture.FrontEndImmBeginDrawCommandList.Info)"                            />
					<event symbol="CommandListCompositeTrimInfo"                                                 value="108" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeTrimInfo"                                                 message="$(string.CommandListComposite.Trim.Info)"                                                 />
					<event symbol="ScrollingLayerScrollToInfo"                                                   value="109" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerScrollToInfo"                                                   message="$(string.ScrollingLayer.ScrollTo.Info)"                                                   />
					<event symbol="CommandListCompositeDrawStop"                                                 value="110" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Stop"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeDrawStop"                                                 message="$(string.CommandListComposite.Draw.Stop)"                                                 />
					<event symbol="ScrollingLayerZoomToInfo"                                                     value="111" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerZoomToInfo"                                                     message="$(string.ScrollingLayer.ZoomTo.Info)"                                                     />
					<event symbol="VirtualTextureFrontEndImmResizeInfo"                                          value="112" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndImmResizeInfo"                                          message="$(string.VirtualTexture.FrontEndImmResize.Info)"                                          />
					<event symbol="CommandListCompositeDrawStart"                                                value="113" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListComposite"                    opcode="win:Start"                                      keywords="BackEnd Texture CommandList"           template="tidCommandListCompositeDrawStart"                                                message="$(string.CommandListComposite.Draw.Start)"                                                />
					<event symbol="Direct2DTextureFrontEndImmBeginDrawSurfaceInfo"                               value="114" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureFrontEndImmBeginDrawSurfaceInfo"                               message="$(string.Direct2DTexture.FrontEndImmBeginDrawSurface.Info)"                               />
					<event symbol="Direct2DTextureFrontEndImmEndDrawStart"                                       value="115" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Start"                                      keywords="FrontEnd Texture"                      template="tidDirect2DTextureFrontEndImmEndDrawStart"                                       message="$(string.Direct2DTexture.FrontEndImmEndDraw.Start)"                                       />
					<event symbol="CommandListVirtualTextureCreateSurfaceInfo"                                   value="116" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTexture"               opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureCreateSurfaceInfo"                                   message="$(string.CommandListVirtualTexture.CreateSurface.Info)"                                   />
					<event symbol="Direct2DTextureFrontEndImmResizeInfo"                                         value="117" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureFrontEndImmResizeInfo"                                         message="$(string.Direct2DTexture.FrontEndImmResize.Info)"                                         />
					<event symbol="CommandListVirtualTextureCreateInfo"                                          value="118" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTexture"               opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureCreateInfo"                                          message="$(string.CommandListVirtualTexture.Create.Info)"                                          />
					<event symbol="Direct2DTextureCreateSurfaceInfo"                                             value="119" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidDirect2DTextureCreateSurfaceInfo"                                             message="$(string.Direct2DTexture.CreateSurface.Info)"                                             />
					<event symbol="VSISTileCreateSurfaceInfo"                                                    value="120" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VSISTile"                                opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVSISTileCreateSurfaceInfo"                                                    message="$(string.VSISTile.CreateSurface.Info)"                                                    />
					<event symbol="Direct2DTextureFrontEndImmBeginDrawDirect2dStop"                              value="121" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Stop"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureFrontEndImmBeginDrawDirect2dStop"                              message="$(string.Direct2DTexture.FrontEndImmBeginDrawDirect2d.Stop)"                              />
					<event symbol="Direct2DTextureFrontEndImmBeginDrawDirect2dStart"                             value="122" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Start"                                      keywords="FrontEnd Texture"                      template="tidDirect2DTextureFrontEndImmBeginDrawDirect2dStart"                             message="$(string.Direct2DTexture.FrontEndImmBeginDrawDirect2d.Start)"                             />
					<event symbol="Direct2DTextureConstructInfo"                                                 value="123" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidDirect2DTextureConstructInfo"                                                 message="$(string.Direct2DTexture.Construct.Info)"                                                 />
					<event symbol="Direct2DTextureFrontEndImmEndDrawStop"                                        value="124" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Stop"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureFrontEndImmEndDrawStop"                                        message="$(string.Direct2DTexture.FrontEndImmEndDraw.Stop)"                                        />
					<event symbol="VSISTileConstructInfo"                                                        value="125" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VSISTile"                                opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVSISTileConstructInfo"                                                        message="$(string.VSISTile.Construct.Info)"                                                        />
					<event symbol="CommandListVirtualTextureScrollViewerRelationshipInfo"                        value="126" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTexture"               opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureScrollViewerRelationshipInfo"                        message="$(string.CommandListVirtualTexture.ScrollViewerRelationship.Info)"                        />
					<event symbol="VirtualTextureScrollViewerRelationshipInfo"                                   value="127" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureScrollViewerRelationshipInfo"                                   message="$(string.VirtualTexture.ScrollViewerRelationship.Info)"                                   />
					<event symbol="SceneDCreateTextureFromWicBitmapExceededMaxDimensionInfo"                     value="128" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SceneD"                                  opcode="win:Info"                                       keywords="Texture Desktop MaxTextureDimension"   template="tidExceededMaxDimensionInfo"                                                     message="$(string.SceneD.CreateTextureFromWicBitmapExceededMaxDimension.Info)"                     />
					<event symbol="LayerHostDInternalOnSizeExceededMaxDimensionInfo"                             value="129" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="LayerHostD"                              opcode="win:Info"                                       keywords="Desktop MaxTextureDimension"           template="tidExceededMaxDimensionInfo"                                                     message="$(string.LayerHostD.InternalOnSizeExceededMaxDimension.Info)"                             />
					<event symbol="SurfaceManagerRequestSurfaceExceededMaxDimensionInfo"                         value="130" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SurfaceManager"                          opcode="win:Info"                                       keywords="Desktop MaxTextureDimension"           template="tidExceededMaxDimensionInfo"                                                     message="$(string.SurfaceManager.RequestSurfaceExceededMaxDimension.Info)"                         />
					<event symbol="WetInkTextureResizeExceededMaxDimensionInfo"                                  value="131" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="WetInkTexture"                           opcode="win:Info"                                       keywords="Texture MaxTextureDimension"           template="tidExceededMaxDimensionInfo"                                                     message="$(string.WetInkTexture.ResizeExceededMaxDimension.Info)"                                  />
					<event symbol="SceneCreateSwapChainTextureExceededMaxDimensionInfo"                          value="132" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="Scene"                                   opcode="win:Info"                                       keywords="Texture MaxTextureDimension"           template="tidExceededMaxDimensionInfo"                                                     message="$(string.Scene.CreateSwapChainTextureExceededMaxDimension.Info)"                          />
					<event symbol="LayerHostIInternalOnSizeExceededMaxDimensionInfo"                             value="133" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="LayerHostI"                              opcode="win:Info"                                       keywords="Immersive MaxTextureDimension"         template="tidExceededMaxDimensionInfo"                                                     message="$(string.LayerHostI.InternalOnSizeExceededMaxDimension.Info)"                             />
					<event symbol="SceneICreateTextureFromWicBitmapExceededMaxDimensionInfo"                     value="134" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SceneI"                                  opcode="win:Info"                                       keywords="Texture Immersive MaxTextureDimension" template="tidExceededMaxDimensionInfo"                                                     message="$(string.SceneI.CreateTextureFromWicBitmapExceededMaxDimension.Info)"                     />
					<event symbol="SceneDCreateGdiTextureExceededMaxDimensionInfo"                               value="135" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SceneD"                                  opcode="win:Info"                                       keywords="Texture MaxTextureDimension"           template="tidExceededMaxDimensionInfo"                                                     message="$(string.SceneD.CreateGdiTextureExceededMaxDimension.Info)"                               />
					<event symbol="Direct2DTextureBeginDrawNullRenderTargetInfo"                                 value="136" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Info"                                       keywords="FrontEnd Texture NullRenderTarget"     template="tidNullRenderTargetInfo"                                                         message="$(string.Direct2DTexture.BeginDrawNullRenderTarget.Info)"                                 />
					<event symbol="VirtualTextureBeginDrawDirect2dNullRenderTargetInfo"                          value="137" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture NullRenderTarget"     template="tidNullRenderTargetInfo"                                                         message="$(string.VirtualTexture.BeginDrawDirect2dNullRenderTarget.Info)"                          />
					<event symbol="ScrollingLayerOnViewChangingInfo"                                             value="138" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerOnViewChangingInfo"                                             message="$(string.ScrollingLayer.OnViewChanging.Info)"                                             />
					<event symbol="ScrollingLayerOnViewChangedInfo"                                              value="139" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerOnViewChangedInfo"                                              message="$(string.ScrollingLayer.OnViewChanged.Info)"                                              />
					<event symbol="WetInkTextureInkInputModeInfo"                                                value="140" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkTexture"                           opcode="win:Info"                                       keywords="BackEnd Texture WetInk"                template="tidWetInkTextureInkInputModeInfo"                                                message="$(string.WetInkTexture.InkInputMode.Info)"                                                />
					<event symbol="WetInkTextureCompletedPenStrokeInfo"                                          value="141" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkTexture"                           opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkTextureCompletedPenStrokeInfo"                                          message="$(string.WetInkTexture.CompletedPenStroke.Info)"                                          />
					<event symbol="XamlHostingLayerSetDirectionalityInfo"                                        value="142" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlHostingLayer"                        opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidSetDirectionalityInfo"                                                        message="$(string.XamlHostingLayer.SetDirectionality.Info)"                                        />
					<event symbol="ScrollingLayerSetDirectionalityInfo"                                          value="143" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidSetDirectionalityInfo"                                                        message="$(string.ScrollingLayer.SetDirectionality.Info)"                                          />
					<event symbol="WetInkSwapChainPanelDrawInkInfo"                                              value="144" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelDrawInkInfo"                                              message="$(string.WetInkSwapChainPanel.DrawInk.Info)"                                              />
					<event symbol="BasicSwapChainPanelClearStop"                                                 value="145" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Stop"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelClearStop"                                                 message="$(string.BasicSwapChainPanel.Clear.Stop)"                                                 />
					<event symbol="BasicSwapChainPanelClearStart"                                                value="146" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Start"                                      keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelClearStart"                                                message="$(string.BasicSwapChainPanel.Clear.Start)"                                                />
					<event symbol="BasicSwapChainPanelCreateDeviceResourcesStart"                                value="147" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Start"                                      keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelCreateDeviceResourcesStart"                                message="$(string.BasicSwapChainPanel.CreateDeviceResources.Start)"                                />
					<event symbol="BasicSwapChainPanelCreateSizeDependentResourcesOnUIThreadStop"                value="148" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Stop"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelCreateSizeDependentResourcesOnUIThreadStop"                message="$(string.BasicSwapChainPanel.CreateSizeDependentResourcesOnUIThread.Stop)"                />
					<event symbol="BasicSwapChainPanelCreateSizeDependentResourcesOnUIThreadStart"               value="149" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Start"                                      keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelCreateSizeDependentResourcesOnUIThreadStart"               message="$(string.BasicSwapChainPanel.CreateSizeDependentResourcesOnUIThread.Start)"               />
					<event symbol="BasicSwapChainPanelOnAppSuspendingInfo"                                       value="150" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelOnAppSuspendingInfo"                                       message="$(string.BasicSwapChainPanel.OnAppSuspending.Info)"                                       />
					<event symbol="BasicSwapChainPanelOnAppResumingInfo"                                         value="151" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelOnAppResumingInfo"                                         message="$(string.BasicSwapChainPanel.OnAppResuming.Info)"                                         />
					<event symbol="BasicSwapChainPanelCreateDeviceResourcesStop"                                 value="152" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Stop"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelCreateDeviceResourcesStop"                                 message="$(string.BasicSwapChainPanel.CreateDeviceResources.Stop)"                                 />
					<event symbol="Direct2DTextureSetDpiInfo"                                                    value="153" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSetDpiInfo"                                                                   message="$(string.Direct2DTexture.SetDpi.Info)"                                                    />
					<event symbol="VirtualTextureSetDpiInfo"                                                     value="154" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSetDpiInfo"                                                                   message="$(string.VirtualTexture.SetDpi.Info)"                                                     />
					<event symbol="WetInkTextureSetDpiInfo"                                                      value="155" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkTexture"                           opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidWetInkTextureSetDpiInfo"                                                      message="$(string.WetInkTexture.SetDpi.Info)"                                                      />
					<event symbol="StoryboardQueued"                                                             value="156" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidStoryboard"                                                                   />
					<event symbol="AnimationScheduleStartEtw"                                                    value="157" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Start"                                      keywords="Animation Timing"                      />
					<event symbol="AnimationScheduleEndEtw"                                                      value="158" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Stop"                                       keywords="Animation Timing"                      />
					<event symbol="LayerHitTestStart"                                                            value="159" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Layer"                                   opcode="win:Start"                                      keywords="FrontEnd Layer"                        template="tidHitTestStart"                                                                 message="$(string.Layer.HitTest.Start)"                                                            />
					<event symbol="SceneIsLayerHitStop"                                                          value="160" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Scene"                                   opcode="win:Stop"                                       keywords="FrontEnd Scene"                        template="tidSceneIsLayerHitStop"                                                          message="$(string.Scene.IsLayerHit.Stop)"                                                          />
					<event symbol="SceneIsLayerHitStart"                                                         value="161" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Scene"                                   opcode="win:Start"                                      keywords="FrontEnd Scene"                        template="tidHitTestStart"                                                                 message="$(string.Scene.IsLayerHit.Start)"                                                         />
					<event symbol="LayerHitTestStop"                                                             value="162" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Layer"                                   opcode="win:Stop"                                       keywords="FrontEnd Layer"                        template="tidLayerHitTestStop"                                                             message="$(string.Layer.HitTest.Stop)"                                                             />
					<event symbol="XamlVirtualSurfaceEndDrawStart"                                               value="163" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlVirtualSurfaceEndDrawStart"                                               message="$(string.XamlVirtualizedSurface.EndDraw.Start)"                                           />
					<event symbol="XamlVirtualSurfaceEndDrawStop"                                                value="164" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualSurfaceEndDrawStart"                                               message="$(string.XamlVirtualizedSurface.EndDraw.Stop)"                                            />
					<event symbol="BasicSwapChainPanelIsReadyToPresentInfo"                                      value="165" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelIsReadyToPresentInfo"                                      message="$(string.BasicSwapChainPanel.IsReadyToPresent.Info)"                                      />
					<event symbol="WetInkSwapChainPanelEmitPostPresentDataInfo"                                  value="166" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelEmitPostPresentDataInfo"                                  message="$(string.WetInkSwapChainPanel.EmitPostPresentData.Info)"                                  />
					<event symbol="WetInkSwapChainPanelDrawInkErrorInfo"                                         value="167" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelDrawInkErrorInfo"                                         message="$(string.WetInkSwapChainPanel.DrawInkError.Info)"                                         />
					<event symbol="WetInkSwapChainPanelRefreshInfo"                                              value="168" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelRefreshInfo"                                              message="$(string.WetInkSwapChainPanel.Refresh.Info)"                                              />
					<event symbol="WetInkSwapChainPanelDrawInkStart"                                             value="169" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Start"                                      keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelDrawInkStart"                                             message="$(string.WetInkSwapChainPanel.DrawInk.Start)"                                             />
					<event symbol="WetInkSwapChainPanelRenderAndPresentPointsInfo"                               value="170" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelRenderAndPresentPointsInfo"                               message="$(string.WetInkSwapChainPanel.RenderAndPresentPoints.Info)"                               />
					<event symbol="WetInkSwapChainPanelProcessPresentStatisticsWarningInfo"                      value="171" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelProcessPresentStatisticsWarningInfo"                      message="$(string.WetInkSwapChainPanel.ProcessPresentStatisticsWarning.Info)"                      />
					<event symbol="WetInkSwapChainPanelOnPointerReleasedInfo"                                    value="172" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelOnPointerReleasedInfo"                                    message="$(string.WetInkSwapChainPanel.OnPointerReleased.Info)"                                    />
					<event symbol="BasicSwapChainPanelAddToEtwLogIfFailedInfo"                                   value="173" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelAddToEtwLogIfFailedInfo"                                   message="$(string.BasicSwapChainPanel.AddToEtwLogIfFailed.Info)"                                   />
					<event symbol="WetInkSwapChainPanelOnStrokesMoveCompletedInfo"                               value="174" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelOnStrokesMoveCompletedInfo"                               message="$(string.WetInkSwapChainPanel.OnStrokesMoveCompleted.Info)"                               />
					<event symbol="WetInkSwapChainPanelOnInkPointsAvailableInfo"                                 value="175" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelOnInkPointsAvailableInfo"                                 message="$(string.WetInkSwapChainPanel.OnInkPointsAvailable.Info)"                                 />
					<event symbol="BasicSwapChainPanelGetFrameStatisticsInfo"                                    value="176" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelGetFrameStatisticsInfo"                                    message="$(string.BasicSwapChainPanel.GetFrameStatistics.Info)"                                    />
					<event symbol="WetInkSwapChainPanelDrawInkStop"                                              value="177" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Stop"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelDrawInkStop"                                              message="$(string.WetInkSwapChainPanel.DrawInk.Stop)"                                              />
					<event symbol="WetInkSwapChainPanelOnInkPointsReceivedInfo"                                  value="178" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelOnInkPointsReceivedInfo"                                  message="$(string.WetInkSwapChainPanel.OnInkPointsReceived.Info)"                                  />
					<event symbol="WetInkSwapChainPanelProcessPresentStatisticsErrorInfo"                        value="179" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelProcessPresentStatisticsErrorInfo"                        message="$(string.WetInkSwapChainPanel.ProcessPresentStatisticsError.Info)"                        />
					<event symbol="BasicSwapChainPanelGetLastPresentCountInfo"                                   value="180" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BasicSwapChainPanel"                     opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidBasicSwapChainPanelGetLastPresentCountInfo"                                   message="$(string.BasicSwapChainPanel.GetLastPresentCount.Info)"                                   />
					<event symbol="WetInkSwapChainPanelProcessPresentStatisticsInfo"                             value="181" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Info"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelProcessPresentStatisticsInfo"                             message="$(string.WetInkSwapChainPanel.ProcessPresentStatistics.Info)"                             />
					<event symbol="WetInkSwapChainPanelRenderAndPresentPointsStop"                               value="182" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Stop"                                       keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelRenderAndPresentPointsStop"                               message="$(string.WetInkSwapChainPanel.RenderAndPresentPoints.Stop)"                               />
					<event symbol="WetInkSwapChainPanelRenderAndPresentPointsStart"                              value="183" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WetInkSwapChainPanel"                    opcode="win:Start"                                      keywords="BackEnd WetInk"                        template="tidWetInkSwapChainPanelRenderAndPresentPointsStart"                              message="$(string.WetInkSwapChainPanel.RenderAndPresentPoints.Start)"                              />
					<event symbol="XamlDrawableSurfaceSuspendDrawStart"                                          value="184" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceSuspendDrawStart"                                          message="$(string.XamlDrawableSurface.SuspendDraw.Start)"                                          />
					<event symbol="XamlMultithreadDrawableSurfaceOffThreadConstructInfo"                         value="185" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadDrawableSurfaceOffThread" opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlMultithreadDrawableSurfaceOffThreadConstructInfo"                         message="$(string.XamlMultithreadDrawableSurfaceOffThread.Construct.Info)"                         />
					<event symbol="XamlDrawableSurfaceSetDeviceStart"                                            value="186" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="Texture"                               template="tidXamlDrawableSurfaceSetDeviceStart"                                            message="$(string.XamlDrawableSurface.SetDevice.Start)"                                            />
					<event symbol="XamlMultithreadDrawableSurfaceOffThreadEndDrawStop"                           value="187" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadDrawableSurfaceOffThread" opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlMultithreadDrawableSurfaceOffThreadEndDrawStop"                           message="$(string.XamlMultithreadDrawableSurfaceOffThread.EndDraw.Stop)"                           />
					<event symbol="XamlDrawableSurfaceEndDrawDirect2dStop"                                       value="188" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceEndDrawDirect2dStop"                                       message="$(string.XamlDrawableSurface.EndDrawDirect2d.Stop)"                                       />
					<event symbol="Direct2DTextureXamlMultithreadNativeSurfaceOffThreadInfo"                     value="189" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureXamlMultithreadNativeSurfaceOffThreadInfo"                     message="$(string.Direct2DTexture.XamlMultithreadNativeSurfaceOffThread.Info)"                     />
					<event symbol="XamlDrawableSurfaceFlushWorkStop"                                             value="190" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceFlushWorkStop"                                             message="$(string.XamlDrawableSurface.FlushWork.Stop)"                                             />
					<event symbol="XamlMultithreadDrawableSurfaceOffThreadBeginDrawStart"                        value="191" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadDrawableSurfaceOffThread" opcode="win:Start"                                      keywords="Texture"                               template="tidXamlMultithreadDrawableSurfaceOffThreadBeginDrawStart"                        message="$(string.XamlMultithreadDrawableSurfaceOffThread.BeginDraw.Start)"                        />
					<event symbol="XamlDrawableSurfaceSuspendDrawStop"                                           value="192" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceSuspendDrawStop"                                           message="$(string.XamlDrawableSurface.SuspendDraw.Stop)"                                           />
					<event symbol="XamlDrawableSurfaceBeginDrawNativeSurfaceStart"                               value="193" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceBeginDrawNativeSurfaceStart"                               message="$(string.XamlDrawableSurface.BeginDrawNativeSurface.Start)"                               />
					<event symbol="XamlMultithreadDrawableSurfaceConstructInfo"                                  value="194" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadDrawableSurface"          opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlMultithreadDrawableSurfaceConstructInfo"                                  message="$(string.XamlMultithreadDrawableSurface.Construct.Info)"                                  />
					<event symbol="XamlDrawableSurfaceInternalSetDeviceInfo"                                     value="195" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Info"                                       keywords="Texture"                               template="tidXamlDrawableSurfaceInternalSetDeviceInfo"                                     message="$(string.XamlDrawableSurface.InternalSetDevice.Info)"                                     />
					<event symbol="XamlDrawableSurfaceBeginDrawNativeSurfaceStop"                                value="196" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceBeginDrawNativeSurfaceStop"                                message="$(string.XamlDrawableSurface.BeginDrawNativeSurface.Stop)"                                />
					<event symbol="XamlDrawableSurfaceInitializeSurfaceInfo"                                     value="197" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Info"                                       keywords="Texture"                               template="tidXamlDrawableSurfaceInitializeSurfaceInfo"                                     message="$(string.XamlDrawableSurface.InitializeSurface.Info)"                                     />
					<event symbol="XamlMultithreadNativeSurfaceOffThreadXamlDrawableSurfaceSetDeviceCommandInfo" value="198" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadNativeSurfaceOffThread"   opcode="win:Info"                                       keywords="Texture"                               template="tidXamlMultithreadNativeSurfaceOffThreadXamlDrawableSurfaceSetDeviceCommandInfo" message="$(string.XamlMultithreadNativeSurfaceOffThread.XamlDrawableSurfaceSetDeviceCommand.Info)" />
					<event symbol="XamlDrawableSurfaceEndDrawCommitStop"                                         value="199" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceEndDrawCommitStop"                                         message="$(string.XamlDrawableSurface.EndDrawCommit.Stop)"                                         />
					<event symbol="XamlDrawableSurfaceEndDrawCommitStart"                                        value="200" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceEndDrawCommitStart"                                        message="$(string.XamlDrawableSurface.EndDrawCommit.Start)"                                        />
					<event symbol="XamlMultithreadDrawableSurfaceOffThreadBeginDrawStop"                         value="201" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadDrawableSurfaceOffThread" opcode="win:Stop"                                       keywords="Texture"                               template="tidXamlMultithreadDrawableSurfaceOffThreadBeginDrawStop"                         message="$(string.XamlMultithreadDrawableSurfaceOffThread.BeginDraw.Stop)"                         />
					<event symbol="XamlDrawableSurfaceBeginDrawStart"                                            value="202" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceBeginDrawStart"                                            message="$(string.XamlDrawableSurface.BeginDraw.Start)"                                            />
					<event symbol="XamlMultithreadNativeSurfaceUIOnSurfaceContentsLostInfo"                      value="203" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadNativeSurfaceUI"          opcode="win:Info"                                       keywords="Texture"                               template="tidXamlMultithreadNativeSurfaceUIOnSurfaceContentsLostInfo"                      message="$(string.XamlMultithreadNativeSurfaceUI.OnSurfaceContentsLost.Info)"                      />
					<event symbol="XamlDrawableSurfaceEndDrawDirect2dStart"                                      value="204" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceEndDrawDirect2dStart"                                      message="$(string.XamlDrawableSurface.EndDrawDirect2d.Start)"                                      />
					<event symbol="XamlDrawableSurfaceSetDeviceStop"                                             value="205" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="Texture"                               template="tidXamlDrawableSurfaceSetDeviceStop"                                             message="$(string.XamlDrawableSurface.SetDevice.Stop)"                                             />
					<event symbol="XamlMultithreadDrawableSurfaceOffThreadEndDrawStart"                          value="206" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadDrawableSurfaceOffThread" opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlMultithreadDrawableSurfaceOffThreadEndDrawStart"                          message="$(string.XamlMultithreadDrawableSurfaceOffThread.EndDraw.Start)"                          />
					<event symbol="XamlDrawableSurfaceFlushWorkStart"                                            value="207" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Start"                                      keywords="BackEnd Texture"                       message="$(string.XamlDrawableSurface.FlushWork.Start)"                                   />
					<event symbol="XamlDrawableSurfaceBeginDrawStop"                                             value="208" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlDrawableSurface"                     opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlDrawableSurfaceBeginDrawStop"                                             message="$(string.XamlDrawableSurface.BeginDraw.Stop)"                                             />
					<event symbol="InteractionInstanceOnUpdateStop"                                              value="209" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="InteractionInstance"                     opcode="win:Stop"                                       keywords="Interaction"                           template="tidInteractionInstanceOnUpdateStop"                                              message="$(string.InteractionInstance.OnUpdate.Stop)"                                              />
					<event symbol="InputProcessorOnInteractionStart"                                             value="210" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="InputProcessor"                          opcode="win:Start"                                      keywords="Interaction Pointer"                   template="tidInputProcessorOnInteractionStart"                                             message="$(string.InputProcessor.OnInteraction.Start)"                                             />
					<event symbol="InputProcessorOnInteractionStop"                                              value="211" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="InputProcessor"                          opcode="win:Stop"                                       keywords="Interaction Pointer"                   template="tidInputProcessorOnInteractionStop"                                              message="$(string.InputProcessor.OnInteraction.Stop)"                                              />
					<event symbol="InteractionInstanceOnUpdateInfo"                                              value="212" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="InteractionInstance"                     opcode="win:Info"                                       keywords="Interaction"                           template="tidInteractionInstanceOnUpdateInfo"                                              message="$(string.InteractionInstance.OnUpdate.Info)"                                              />
					<event symbol="ScrollingLayerOnDragOverInfo"                                                 value="213" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer Interaction Immersive"   template="tidScrollingLayerOnDragOverInfo"                                                 message="$(string.ScrollingLayer.OnDragOver.Info)"                                                 />
					<event symbol="InputProcessorHandleLayerInfo"                                                value="214" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="InputProcessor"                          opcode="win:Info"                                       keywords="Interaction Pointer"                   template="tidInputProcessorHandleLayerInfo"                                                message="$(string.InputProcessor.HandleLayer.Info)"                                                />
					<event symbol="InteractionInstanceOnUpdateStart"                                             value="215" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="InteractionInstance"                     opcode="win:Start"                                      keywords="Interaction"                           template="tidInteractionInstanceOnUpdateStart"                                             message="$(string.InteractionInstance.OnUpdate.Start)"                                             />
					<event symbol="CommandListRasterizeWorkDrawStart"                                            value="216" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListRasterizeWork"                opcode="win:Start"                                      keywords="BackEnd Texture CommandList"           template="tidCommandListRasterizeWorkDrawStart"                                            message="$(string.CommandListRasterizeWork.Draw.Start)"                                            />
					<event symbol="CommandListRasterizeWorkDrawStop"                                             value="217" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListRasterizeWork"                opcode="win:Stop"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListRasterizeWorkDrawStop"                                             message="$(string.CommandListRasterizeWork.Draw.Stop)"                                             />
					<event symbol="CommandListRasterizeWorkConstructInfo"                                        value="218" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListRasterizeWork"                opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListRasterizeWorkConstructInfo"                                        message="$(string.CommandListRasterizeWork.Construct.Info)"                                        />
					<event symbol="CommandListRasterizerSubmitWorkInfo"                                          value="219" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListRasterizer"                   opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListRasterizerSubmitWorkInfo"                                          message="$(string.CommandListRasterizer.SubmitWork.Info)"                                          />
					<event symbol="NullDeviceContextCopyTextureToMemory"                                         value="220" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="UpdateTextures"                          opcode="win:Info"                                       keywords="BackEnd Texture"                       />
					<event symbol="VirtualTextureBeginDrawDirect2dInternalExceededMaxDimensionInfo"              value="221" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="VirtualTexture"                          opcode="win:Info"                                       keywords="Texture MaxTextureDimension"           template="tidExceededMaxDimensionInfo"                                                     message="$(string.VirtualTexture.BeginDrawDirect2dInternalExceededMaxDimension.Info)"              />
					<event symbol="CompositorAreAnimationsDisabledInfo"                                          value="222" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidCompositorAreAnimationsDisabledInfo"                                          message="$(string.Compositor.AreAnimationsDisabled.Info)"                                          />
					<event symbol="VSISTilerResizeInfo"                                                          value="223" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VSISTiler"                               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVSISTilerResizeInfo"                                                          message="$(string.VSISTiler.Resize.Info)"                                                          />
					<event symbol="VSISTilerBeginDrawInfo"                                                       value="224" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VSISTiler"                               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVSISTilerBeginDrawInfo"                                                       message="$(string.VSISTiler.BeginDraw.Info)"                                                       />
					<event symbol="VSISTilerInvalidateRectInfo"                                                  value="225" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VSISTiler"                               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVSISTilerInvalidateRectInfo"                                                  message="$(string.VSISTiler.InvalidateRect.Info)"                                                  />
					<event symbol="CommandListVirtualTextureBeginDrawInfo"                                       value="226" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTexture"               opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureBeginDrawInfo"                                       message="$(string.CommandListVirtualTexture.BeginDraw.Info)"                                       />
					<event symbol="CommandListVirtualTextureEndDrawInfo"                                         value="227" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTexture"               opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureEndDrawInfo"                                         message="$(string.CommandListVirtualTexture.EndDraw.Info)"                                         />
					<event symbol="VSISTilerInitializeInfo"                                                      value="228" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VSISTiler"                               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVSISTilerInitializeInfo"                                                      message="$(string.VSISTiler.Initialize.Info)"                                                      />
					<event symbol="XamlMultithreadDrawableSurfaceOffThreadXamlNativeSurfaceSetDeviceCommandInfo" value="229" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadDrawableSurfaceOffThread" opcode="win:Info"                                       keywords="Texture"                               template="tidXamlMultithreadDrawableSurfaceOffThreadXamlNativeSurfaceSetDeviceCommandInfo" message="$(string.XamlMultithreadDrawableSurfaceOffThread.XamlNativeSurfaceSetDeviceCommand.Info)" />
					<event symbol="XamlVirtualizedSurfaceUpdateRegionRectInfo"                                   value="230" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualizedSurfaceUpdateRegionRectInfo"                                   message="$(string.XamlVirtualizedSurface.UpdateRegionRect.Info)"                                   />
					<event symbol="XamlVirtualizedSurfaceEndDrawStop"                                            value="231" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualizedSurfaceEndDrawStop"                                            message="$(string.XamlVirtualizedSurface.EndDraw.Stop)"                                            />
					<event symbol="XamlVirtualizedSurfaceUpdateRegionStart"                                      value="232" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlVirtualizedSurfaceUpdateRegionStart"                                      message="$(string.XamlVirtualizedSurface.UpdateRegion.Start)"                                      />
					<event symbol="XamlVirtualizedSurfaceInvalidateRectInfo"                                     value="233" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualizedSurfaceInvalidateRectInfo"                                     message="$(string.XamlVirtualizedSurface.InvalidateRect.Info)"                                     />
					<event symbol="XamlVirtualizedSurfaceOnUpdatesNeededInfo"                                    value="234" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualizedSurfaceOnUpdatesNeededInfo"                                    message="$(string.XamlVirtualizedSurface.OnUpdatesNeeded.Info)"                                    />
					<event symbol="XamlVirtualizedSurfaceResizeInfo"                                             value="235" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualizedSurfaceResizeInfo"                                             message="$(string.XamlVirtualizedSurface.Resize.Info)"                                             />
					<event symbol="XamlVirtualizedSurfaceEndDrawStart"                                           value="236" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidXamlVirtualizedSurfaceEndDrawStart"                                           message="$(string.XamlVirtualizedSurface.EndDraw.Start)"                                           />
					<event symbol="XamlVirtualizedSurfaceUpdateRegionStop"                                       value="237" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidXamlVirtualizedSurfaceUpdateRegionStop"                                       message="$(string.XamlVirtualizedSurface.UpdateRegion.Stop)"                                       />
					<event symbol="XamlVirtualSurfaceConstructInfo"                                              value="238" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualSurface"                      opcode="win:Info"                                       keywords="Texture"                               template="tidXamlVirtualSurfaceConstructInfo"                                              message="$(string.XamlVirtualSurface.Construct.Info)"                                              />
					<event symbol="XamlMultithreadNativeSurfaceConstructInfo"                                    value="239" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadNativeSurface"            opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlMultithreadNativeSurfaceConstructInfo"                                    message="$(string.XamlMultithreadNativeSurface.Construct.Info)"                                    />
					<event symbol="XamlSurfaceConstructInfo"                                                     value="240" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlSurface"                             opcode="win:Info"                                       keywords="Texture"                               template="tidXamlSurfaceConstructInfo"                                                     message="$(string.XamlSurface.Construct.Info)"                                                     />
					<event symbol="VirtualTextureVirtualTextureStart"                                            value="241" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Start"                                      keywords="BackEnd Texture"                       template="tidVirtualTextureVirtualTextureStart"                                            message="$(string.VirtualTexture.VirtualTexture.Start)"                                            />
					<event symbol="VirtualTextureVirtualTextureStop"                                             value="242" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Stop"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureVirtualTextureStop"                                             message="$(string.VirtualTexture.VirtualTexture.Stop)"                                             />
					<event symbol="XamlMultithreadVirtualSurfaceConstructInfo"                                   value="243" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlMultithreadVirtualSurface"           opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidXamlMultithreadVirtualSurfaceConstructInfo"                                   message="$(string.XamlMultithreadVirtualSurface.Construct.Info)"                                   />
					<event symbol="XamlVirtualizedSurfaceConstructInfo"                                          value="244" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualizedSurface"                  opcode="win:Info"                                       keywords="Texture"                               template="tidXamlVirtualizedSurfaceConstructInfo"                                          message="$(string.XamlVirtualizedSurface.Construct.Info)"                                          />
					<event symbol="XamlVirtualSurfaceEndDrawInvalidateStart"                                     value="245" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualSurface"                      opcode="win:Start"                                      keywords="Texture"                               template="tidXamlVirtualSurfaceEndDrawInvalidateStart"                                     message="$(string.XamlVirtualSurface.EndDrawInvalidate.Start)"                                     />
					<event symbol="XamlVirtualSurfaceEndDrawInvalidateStop"                                      value="246" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualSurface"                      opcode="win:Stop"                                       keywords="Texture"                               template="tidXamlVirtualSurfaceEndDrawInvalidateStop"                                      message="$(string.XamlVirtualSurface.EndDrawInvalidate.Stop)"                                      />
					<event symbol="XamlVirtualSurfaceEndDrawResizeInfo"                                          value="247" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="XamlVirtualSurface"                      opcode="win:Info"                                       keywords="Texture"                               template="tidXamlVirtualSurfaceEndDrawResizeInfo"                                          message="$(string.XamlVirtualSurface.EndDrawResize.Info)"                                          />
					<event symbol="RenderingDeviceLost"                                                          value="248" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="GPU"                                   template="tidRenderingDeviceLost"                                                          message="$(string.Compositor.RenderingDeviceLost.Info)"                                            />
					<event symbol="HitTestSlopInfo"                                                              value="249" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidHitTestSlopInfo"                                                              message="$(string.VirtualTexture.HitTestSlopInfo.Info)"                                            />
					<event symbol="ScrollingLayerBigGridScrollToInfo"                                            value="250" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerBigGridScrollToInfo"                                            message="$(string.ScrollingLayer.BigGridScrollTo.Info)"                                            />
					<event symbol="ScrollingLayerBigGridAdjustViewportPositionInfo"                              value="251" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerBigGridAdjustViewportPositionInfo"                              message="$(string.ScrollingLayer.BigGridAdjustViewportPosition.Info)"                              />
					<event symbol="BitmapAllocatorBitmapMemoryExceededMaxLimitInfo"                              value="252" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BitmapAllocator"                         opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidBitmapAllocatorBitmapMemoryExceededMaxLimitInfo"                              message="$(string.BitmapAllocator.BitmapMemoryExceededMaxLimit.Info)"                              />
					<event symbol="MemoryHelperLowResourceModeStatusChangeInfo"                                  value="253" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="MemoryHelper"                            opcode="win:Info"                                       keywords="Memory"                                template="tidMemoryHelperLowResourceModeStatusChangeInfo"                                  message="$(string.MemoryHelper.LowResourceModeStatusChange.Info)"                                  />
					<event symbol="BlockingCommandCancelledDuringSuspend"                                        value="254" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SceneI"                                  opcode="win:Info"                                       keywords="FrontEnd Channel"                      template="tidOneUint"                                                                      />
					<event symbol="ScrollingLayerArrangeOverrideInfo"                                            value="257" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerArrangeOverrideInfo"                                            message="$(string.ScrollingLayer.ArrangeOverride.Info)"                                            />
					<event symbol="ScrollingLayerResetPendingScrollToInfo"                                       value="258" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerResetPendingScrollToInfo"                                       message="$(string.ScrollingLayer.ResetPendingScrollTo.Info)"                                       />
					<event symbol="ScrollingLayerResetPendingZoomToInfo"                                         value="259" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerResetPendingZoomToInfo"                                         message="$(string.ScrollingLayer.ResetPendingZoomTo.Info)"                                         />
					<event symbol="BackEndLayerHandlePropertyChangeInfo"                                         value="260" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerHandlePropertyChangeInfo"                                         message="$(string.BackEndLayer.HandlePropertyChange.Info)"                                         />
					<event symbol="BackEndLayerSetBottomInfo"                                                    value="261" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerSetBottomInfo"                                                    message="$(string.BackEndLayer.SetBottom.Info)"                                                    />
					<event symbol="BackEndLayerSetTopInfo"                                                       value="262" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerSetTopInfo"                                                       message="$(string.BackEndLayer.SetTop.Info)"                                                       />
					<event symbol="ScrollingLayerAdjustVirtualizedSpaceInfo"                                     value="263" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerAdjustVirtualizedSpaceInfo"                                     message="$(string.ScrollingLayer.AdjustVirtualizedSpace.Info)"                                     />
					<event symbol="BackEndLayerSetWidthInfo"                                                     value="264" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerSetWidthInfo"                                                     message="$(string.BackEndLayer.SetWidth.Info)"                                                     />
					<event symbol="BackEndLayerUpdateHeightPropsInfo"                                            value="265" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerUpdateHeightPropsInfo"                                            message="$(string.BackEndLayer.UpdateHeightProps.Info)"                                            />
					<event symbol="BackEndLayerSetLeftInfo"                                                      value="266" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerSetLeftInfo"                                                      message="$(string.BackEndLayer.SetLeft.Info)"                                                      />
					<event symbol="ScrollingLayerApplyScrollInfo"                                                value="268" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerApplyScrollInfo"                                                message="$(string.ScrollingLayer.ApplyScroll.Info)"                                                />
					<event symbol="BackEndLayerAdjustVisibleTileInfo"                                            value="269" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerAdjustVisibleTileInfo"                                            message="$(string.BackEndLayer.AdjustVisibleTile.Info)"                                            />
					<event symbol="BackEndLayerSetHeightInfo"                                                    value="270" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerSetHeightInfo"                                                    message="$(string.BackEndLayer.SetHeight.Info)"                                                    />
					<event symbol="BackEndLayerCreateTileInfo"                                                   value="271" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerCreateTileInfo"                                                   message="$(string.BackEndLayer.CreateTile.Info)"                                                   />
					<event symbol="ScrollingLayerOnViewChangingNextFinalInfo"                                    value="272" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerOnViewChangingNextFinalInfo"                                    message="$(string.ScrollingLayer.OnViewChangingNextFinal.Info)"                                    />
					<event symbol="ScrollingLayerGetVirtualPerimeterOffsetInfo"                                  value="273" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerGetVirtualPerimeterOffsetInfo"                                  message="$(string.ScrollingLayer.GetVirtualPerimeterOffset.Info)"                                  />
					<event symbol="BackEndLayerDeleteTileInfo"                                                   value="274" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerDeleteTileInfo"                                                   message="$(string.BackEndLayer.DeleteTile.Info)"                                                   />
					<event symbol="ScrollingLayerFireNotificationsInfo"                                          value="275" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerFireNotificationsInfo"                                          message="$(string.ScrollingLayer.FireNotifications.Info)"                                          />
					<event symbol="BackEndLayerSetRightInfo"                                                     value="277" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerSetRightInfo"                                                     message="$(string.BackEndLayer.SetRight.Info)"                                                     />
					<event symbol="BackEndLayerEnsureBrushTransformInfo"                                         value="278" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerEnsureBrushTransformInfo"                                         message="$(string.BackEndLayer.EnsureBrushTransform.Info)"                                         />
					<event symbol="BackEndLayerPropogateVirtualizedRectMismatchInfo"                             value="280" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerPropogateVirtualizedRectMismatchInfo"                             message="$(string.BackEndLayer.PropogateVirtualizedRectMismatch.Info)"                             />
					<event symbol="BackEndLayerPropogateVirtualizationChangedInfo"                               value="281" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerPropogateVirtualizationChangedInfo"                               message="$(string.BackEndLayer.PropogateVirtualizationChanged.Info)"                               />
					<event symbol="BackEndLayerUpdateWidthPropsInfo"                                             value="282" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerUpdateWidthPropsInfo"                                             message="$(string.BackEndLayer.UpdateWidthProps.Info)"                                             />
					<event symbol="ScrollingLayerClientScrollToInfo"                                             value="283" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerClientScrollToInfo"                                             message="$(string.ScrollingLayer.ClientScrollTo.Info)"                                             />
					<event symbol="BackEndLayerHandleVirtualizationChangedInfo"                                  value="284" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerHandleVirtualizationChangedInfo"                                  message="$(string.BackEndLayer.HandleVirtualizationChanged.Info)"                                  />
					<event symbol="BackEndLayerVirtualizeTextureInfo"                                            value="285" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerVirtualizeTextureInfo"                                            message="$(string.BackEndLayer.VirtualizeTexture.Info)"                                            />
					<event symbol="BackEndLayerGetVirtualPerimeterInfo"                                          value="286" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerGetVirtualPerimeterInfo"                                          message="$(string.BackEndLayer.GetVirtualPerimeter.Info)"                                          />
					<event symbol="BackEndLayerLayoutChangedInfo"                                                value="287" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerLayoutChangedInfo"                                                message="$(string.BackEndLayer.LayoutChanged.Info)"                                                />
					<event symbol="BackEndLayerVirtualizationChangedInfo"                                        value="288" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerVirtualizationChangedInfo"                                        message="$(string.BackEndLayer.VirtualizationChanged.Info)"                                        />
					<event symbol="BackEndLayerUpdateBorderLayoutInfo"                                           value="289" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerUpdateBorderLayoutInfo"                                           message="$(string.BackEndLayer.UpdateBorderLayout.Info)"                                           />
					<event symbol="BackEndLayerHitTestLayerBoundsInfo"                                           value="290" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerHitTestLayerBoundsInfo"                                           message="$(string.BackEndLayer.HitTestLayerBounds.Info)"                                           />
					<event symbol="BackEndLayerHitTestInfo"                                                      value="291" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerHitTestInfo"                                                      message="$(string.BackEndLayer.HitTest.Info)"                                                      />
					<event symbol="BackEndLayerEvaluateLayerProximityInfo"                                       value="292" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerEvaluateLayerProximityInfo"                                       message="$(string.BackEndLayer.EvaluateLayerProximity.Info)"                                       />
					<event symbol="ScrollingLayerCanvasQueueZoomToInfo"                                          value="293" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerCanvas"                    opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCanvasQueueZoomToInfo"                                          message="$(string.ScrollingLayerCanvas.QueueZoomTo.Info)"                                          />
					<event symbol="ScrollingLayerCanvasQueueSetCanvasSizeInfo"                                   value="294" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerCanvas"                    opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCanvasQueueSetCanvasSizeInfo"                                   message="$(string.ScrollingLayerCanvas.QueueSetCanvasSize.Info)"                                   />
					<event symbol="ScrollingLayerCanvasArrangeOverrideInfo"                                      value="295" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerCanvas"                    opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCanvasArrangeOverrideInfo"                                      message="$(string.ScrollingLayerCanvas.ArrangeOverride.Info)"                                      />
					<event symbol="ScrollingLayerCanvasQueueScrollToInfo"                                        value="296" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerCanvas"                    opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCanvasQueueScrollToInfo"                                        message="$(string.ScrollingLayerCanvas.QueueScrollTo.Info)"                                        />
					<event symbol="ScrollingLayerCanvasScrollToInfo"                                             value="297" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerCanvas"                    opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCanvasScrollToInfo"                                             message="$(string.ScrollingLayerCanvas.ScrollTo.Info)"                                             />
					<event symbol="ScrollingLayerCanvasZoomToInfo"                                               value="298" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerCanvas"                    opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCanvasZoomToInfo"                                               message="$(string.ScrollingLayerCanvas.ZoomTo.Info)"                                               />
					<event symbol="ScrollingLayerCanvasSetCanvasSizeInfo"                                        value="299" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerCanvas"                    opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCanvasSetCanvasSizeInfo"                                        message="$(string.ScrollingLayerCanvas.SetCanvasSize.Info)"                                        />
					<event symbol="DxWarningEtw"                                                                 value="300" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectX"                                 opcode="win:Info"                                       keywords="DirectX"                               template="tidDxError"                                                                      />
					<event symbol="AirSpaceSetDeviceModeInfo"                                                    value="301" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="AirSpace"                                opcode="win:Info"                                       keywords="DirectX"                               template="tidAirSpaceSetDeviceModeInfo"                                                    message="$(string.AirSpace.SetDeviceMode.Info)"                                                    />
					<event symbol="SceneOnDeviceUpdatedInfo"                                                     value="302" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Scene"                                   opcode="win:Info"                                       keywords="DirectX FrontEnd"                      template="tidSceneOnDeviceUpdatedInfo"                                                     message="$(string.Scene.OnDeviceUpdated.Info)"                                                     />
					<event symbol="AirSpaceForgetDeviceInfo"                                                     value="303" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="AirSpace"                                opcode="win:Info"                                       keywords="DirectX"                               template="tidAirSpaceForgetDeviceInfo"                                                     message="$(string.AirSpace.ForgetDevice.Info)"                                                     />
					<event symbol="CompositorSetDeviceModeInfo"                                                  value="304" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="DirectX BackEnd"                       template="tidCompositorSetDeviceModeInfo"                                                  message="$(string.Compositor.SetDeviceMode.Info)"                                                  />
					<event symbol="DirectXDeviceResourcesGetDeviceAccessInfo"                                    value="305" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectXDeviceResources"                  opcode="win:Info"                                       keywords="DirectX"                               template="tidDirectXDeviceResourcesGetDeviceAccessInfo"                                    message="$(string.DirectXDeviceResources.GetDeviceAccess.Info)"                                    />
					<event symbol="Direct2dDeviceResourcesGetDeviceAccessInfo"                                   value="306" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2dDeviceResources"                 opcode="win:Info"                                       keywords="DirectX"                               template="tidDirect2dDeviceResourcesGetDeviceAccessInfo"                                   message="$(string.Direct2dDeviceResources.GetDeviceAccess.Info)"                                   />
					<event symbol="SceneIsDeviceLostNotificationPendingInfo"                                     value="307" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Scene"                                   opcode="win:Info"                                       keywords="DirectX"                               template="tidSceneIsDeviceLostNotificationPendingInfo"                                     message="$(string.Scene.IsDeviceLostNotificationPending.Info)"                                     />
					<event symbol="DirectXDeviceResourcesDeviceLostInfo"                                         value="308" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectXDeviceResources"                  opcode="win:Info"                                       keywords="DirectX"                               template="tidDirectXDeviceResourcesDeviceLostInfo"                                         message="$(string.DirectXDeviceResources.DeviceLost.Info)"                                         />
					<event symbol="SceneDiscardAllDeviceResourcesInfo"                                           value="309" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Scene"                                   opcode="win:Info"                                       keywords="DirectX FrontEnd"                      template="tidSceneDiscardAllDeviceResourcesInfo"                                           message="$(string.Scene.DiscardAllDeviceResources.Info)"                                           />
					<event symbol="DirectXDeviceResourcesHandleDeviceLossInfo"                                   value="310" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="DirectXDeviceResources"                  opcode="win:Info"                                       keywords="DirectX"                               template="tidDirectXDeviceResourcesHandleDeviceLossInfo"                                   message="$(string.DirectXDeviceResources.HandleDeviceLoss.Info)"                                   />
					<event symbol="SceneResetAppDeviceInfo"                                                      value="311" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Scene"                                   opcode="win:Info"                                       keywords="DirectX FrontEnd"                      template="tidSceneResetAppDeviceInfo"                                                      message="$(string.Scene.ResetAppDevice.Info)"                                                      />
					<event symbol="Direct2dDeviceResourcesHandleDeviceLossInfo"                                  value="312" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2dDeviceResources"                 opcode="win:Info"                                       keywords="DirectX"                               template="tidDirect2dDeviceResourcesHandleDeviceLossInfo"                                  message="$(string.Direct2dDeviceResources.HandleDeviceLoss.Info)"                                  />
					<event symbol="ScrollingLayerCurrentViewportChangedInfo"                                     value="313" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCurrentViewportChangedInfo"                                     message="$(string.ScrollingLayer.CurrentViewportChanged.Info)"                                     />
					<event symbol="ScrollingLayerSetCanvasSizeStart"                                             value="314" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Start"                                      keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerSetCanvasSizeStart"                                             message="$(string.ScrollingLayer.SetCanvasSize.Start)"                                             />
					<event symbol="ScrollingLayerArrangeStop"                                                    value="315" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Stop"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerArrangeStop"                                                    message="$(string.ScrollingLayer.Arrange.Stop)"                                                    />
					<event symbol="ScrollingLayerMaxViewportDestinationInfo"                                     value="316" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerMaxViewportDestinationInfo"                                     message="$(string.ScrollingLayer.MaxViewportDestination.Info)"                                     />
					<event symbol="ScrollingLayerOnViewChangingNextInfo"                                         value="317" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerOnViewChangingNextInfo"                                         message="$(string.ScrollingLayer.OnViewChangingNext.Info)"                                         />
					<event symbol="ScrollingLayerSetCanvasSizeStop"                                              value="318" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Stop"                                       keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerSetCanvasSizeStop"                                              message="$(string.ScrollingLayer.SetCanvasSize.Stop)"                                              />
					<event symbol="ScrollingLayerFinalViewportChangedInfo"                                       value="319" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerFinalViewportChangedInfo"                                       message="$(string.ScrollingLayer.FinalViewportChanged.Info)"                                       />
					<event symbol="ScrollingLayerArrangeAbortInfo"                                               value="320" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerArrangeAbortInfo"                                               message="$(string.ScrollingLayer.ArrangeAbort.Info)"                                               />
					<event symbol="ScrollingLayerArrangeStart"                                                   value="321" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Start"                                      keywords="BackEnd Layer"                         template="tidScrollingLayerArrangeStart"                                                   message="$(string.ScrollingLayer.Arrange.Start)"                                                   />
					<event symbol="ScrollingLayerCanvasChangeViewInfo"                                           value="322" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerCanvas"                    opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerCanvasChangeViewInfo"                                           message="$(string.ScrollingLayerCanvas.ChangeView.Info)"                                           />
					<event symbol="ScrollingLayerUpdateScrollViewportCommandImmInfo"                             value="323" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerUpdateScrollViewportCommandImmInfo"                             message="$(string.ScrollingLayer.UpdateScrollViewportCommandImm.Info)"                             />
					<event symbol="LocalBlocklistInfo"                                                           value="324" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="GPU DirectX"                           template="tidLocalBlocklistInfo"                                                           message="$(string.AirSpace.LocalBlocklist.Info)"                                                   />
					<event symbol="LocalBlocklistDriverUpdated"                                                  value="325" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="GPU DirectX"                           template="tidLocalBlocklistDriverUpdated"                                                  message="$(string.AirSpace.LocalBlocklist.DriverUpdated)"                                          />
					<event symbol="AnimationPropertyChangeEtw"                                                   value="326" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationPropertyChange"                                                      />
					<event symbol="AnimationInstanceCreationEtw"                                                 value="327" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidAnimationInstanceCreation"                                                    />
					<event symbol="CancelAnimationInstanceBeforeScheduled"                                       value="328" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationInstanceCancellation"                                                />
					<event symbol="CancelAnimationInstanceAfterScheduled"                                        value="329" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationInstanceCancellation"                                                />
					<event symbol="AnimationInstanceCompletion"                                                  value="330" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationInstanceCompletion"                                                  />
					<event symbol="KeyFrameAddedToAnimationInstance"                                             value="331" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidKeyframeAddition"                                                             />
					<event symbol="AddedAnimationClassToAirspaceLayer"                                           value="332" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationClassChange"                                                         />
					<event symbol="RemovedAnimationClassFromAirspaceLayer"                                       value="333" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationClassChange"                                                         />
					<event symbol="RemovedAllAnimationClasses"                                                   value="334" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationClassChangeAll"                                                      />
					<event symbol="ContextVariableProcessed"                                                     value="335" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidContextVariableProcessed"                                                     />
					<event symbol="GraphicsHwCrashUsingSw"                                                       value="336" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="GPU DirectX"                           template="tidGraphicsHwCrashUsingSw"                                                       message="$(string.AirSpace.LocalBlocklist.GraphicsHwCrashUsingSw)"                                 />
					<event symbol="AnimationDisabledReason"                                                      value="337" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidAnimationDisabledReason"                                                      message="$(string.Compositor.AnimationsDisabledReason.Info)"                                       />
					<event symbol="ScrollingLayerCurrentZoomFactorChangedInfo"                                   value="338" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerZoomChangedInfo"                                                message="$(string.ScrollingLayer.CurrentZoomFactorChanged.Info)"                                   />
					<event symbol="ScrollingLayerFinalZoomFactorChangedInfo"                                     value="339" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerZoomChangedInfo"                                                message="$(string.ScrollingLayer.FinalZoomFactorChanged.Info)"                                     />
					<event symbol="ScrollingLayerSetVirtualPerimeterInfo"                                        value="340" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerSetVirtualPerimeterInfo"                                        message="$(string.ScrollingLayer.SetVirtualPerimeter.Info)"                                        />
					<event symbol="ScrollingLayerArrangePendingScrollInfo"                                       value="341" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerArrangePendingScrollInfo"                                       message="$(string.ScrollingLayer.ArrangePendingScroll.Info)"                                       />
					<event symbol="ScrollingLayerFinalPlatformViewportOffsetChangedInfo"                         value="342" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerFinalPlatformViewportOffsetChangedInfo"                         message="$(string.ScrollingLayer.FinalPlatformViewportOffsetChanged.Info)"                         />
					<event symbol="CreateWindowFailure"                                                          value="343" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="Scene"                                   opcode="win:Info"                                       keywords="FrontEnd Scene"                        template="tidOneUint"                                                                      />
					<event symbol="CommandListVirtualTextureWinCompOnAppResumingInfo"                            value="345" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureWinCompOnAppResumingInfo"                            message="$(string.CommandListVirtualTextureWinComp.OnAppResuming.Info)"                            />
					<event symbol="LayerTileManagerResetPrefetchScopeInfo"                                       value="346" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerTileManager"                        opcode="win:Info"                                       keywords="BackEnd Texture LayerTileManager"      template="tidLayerTileManagerResetPrefetchScopeInfo"                                       message="$(string.LayerTileManager.ResetPrefetchScope.Info)"                                       />
					<event symbol="ScrollingLayerWinCompSetupScrollBarsInfo"                                     value="348" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompSetupScrollBarsInfo"                                     message="$(string.ScrollingLayerWinComp.SetupScrollBars.Info)"                                     />
					<event symbol="LayerCommandListVirtualTextureWinCompDestroyInfo"                             value="350" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerCommandListVirtualTextureWinComp"   opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidLayerCommandListVirtualTextureWinCompDestroyInfo"                             message="$(string.LayerCommandListVirtualTextureWinComp.Destroy.Info)"                             />
					<event symbol="SurfaceLayerBitmapTextureWinCompSetTileInfo"                                  value="352" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerBitmapTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSurfaceLayerBitmapTextureWinCompSetTileInfo"                                  message="$(string.SurfaceLayerBitmapTextureWinComp.SetTile.Info)"                                  />
					<event symbol="LayerCommandListVirtualTextureWinCompCreateInfo"                              value="355" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerCommandListVirtualTextureWinComp"   opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidLayerCommandListVirtualTextureWinCompCreateInfo"                              message="$(string.LayerCommandListVirtualTextureWinComp.Create.Info)"                              />
					<event symbol="LayerCommandListVirtualTextureWinCompLayoutChangedInternalInfo"               value="356" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerCommandListVirtualTextureWinComp"   opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidLayerCommandListVirtualTextureWinCompLayoutChangedInternalInfo"               message="$(string.LayerCommandListVirtualTextureWinComp.LayoutChangedInternal.Info)"               />
					<event symbol="CommandListVirtualTextureWinCompDestroyInfo"                                  value="359" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureWinCompDestroyInfo"                                  message="$(string.CommandListVirtualTextureWinComp.Destroy.Info)"                                  />
					<event symbol="LayerCommandListVirtualTextureWinCompResetScrollingLayerParentInternalInfo"   value="362" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerCommandListVirtualTextureWinComp"   opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidLayerCommandListVirtualTextureWinCompResetScrollingLayerParentInternalInfo"   message="$(string.LayerCommandListVirtualTextureWinComp.ResetScrollingLayerParentInternal.Info)"   />
					<event symbol="SurfaceLayerBitmapTextureWinCompCompositionSurfaceChangedInfo"                value="365" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerBitmapTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSurfaceLayerBitmapTextureWinCompCompositionSurfaceChangedInfo"                message="$(string.SurfaceLayerBitmapTextureWinComp.CompositionSurfaceChanged.Info)"                />
					<event symbol="CommandListVirtualTextureWinCompCreateInfo"                                   value="366" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureWinCompCreateInfo"                                   message="$(string.CommandListVirtualTextureWinComp.Create.Info)"                                   />
					<event symbol="BitmapTextureWinCompSetStretchModeInfo"                                       value="371" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BitmapTextureWinComp"                    opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidBitmapTextureWinCompSetStretchModeInfo"                                       message="$(string.BitmapTextureWinComp.SetStretchMode.Info)"                                       />
					<event symbol="VirtualTextureWinCompCreateInfo"                                              value="375" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureWinCompCreateInfo"                                              message="$(string.VirtualTextureWinComp.Create.Info)"                                              />
					<event symbol="VirtualTextureWinCompResizeInfo"                                              value="377" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureWinCompResizeInfo"                                              message="$(string.VirtualTextureWinComp.Resize.Info)"                                              />
					<event symbol="BitmapTextureWinCompCreateInfo"                                               value="379" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BitmapTextureWinComp"                    opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidBitmapTextureWinCompCreateInfo"                                               message="$(string.BitmapTextureWinComp.Create.Info)"                                               />
					<event symbol="VirtualTextureWinCompDestroyInfo"                                             value="381" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureWinCompDestroyInfo"                                             message="$(string.VirtualTextureWinComp.Destroy.Info)"                                             />
					<event symbol="ScrollingLayerWinCompScrollBarIndicatorModeInfo"                              value="382" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompScrollBarIndicatorModeInfo"                              message="$(string.ScrollingLayerWinComp.ScrollBarIndicatorMode.Info)"                              />
					<event symbol="VirtualTextureWinCompSetPrefetchSizeInfo"                                     value="384" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureWinCompSetPrefetchSizeInfo"                                     message="$(string.VirtualTextureWinComp.SetPrefetchSize.Info)"                                     />
					<event symbol="BitmapTextureWinCompDestroyInfo"                                              value="385" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BitmapTextureWinComp"                    opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidBitmapTextureWinCompDestroyInfo"                                              message="$(string.BitmapTextureWinComp.Destroy.Info)"                                              />
					<event symbol="LayerVirtualTextureWinCompCreateInfo"                                         value="386" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerVirtualTextureWinComp"              opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidLayerVirtualTextureWinCompCreateInfo"                                         message="$(string.LayerVirtualTextureWinComp.Create.Info)"                                         />
					<event symbol="SurfaceLayerBitmapTextureWinCompOnLayerSizeChangedInfo"                       value="390" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerBitmapTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSurfaceLayerBitmapTextureWinCompOnLayerSizeChangedInfo"                       message="$(string.SurfaceLayerBitmapTextureWinComp.OnLayerSizeChanged.Info)"                       />
					<event symbol="SurfaceLayerBitmapTextureWinCompApplyStretchModeInfo"                         value="394" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerBitmapTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSurfaceLayerBitmapTextureWinCompApplyStretchModeInfo"                         message="$(string.SurfaceLayerBitmapTextureWinComp.ApplyStretchMode.Info)"                         />
					<event symbol="BitmapTextureWinCompCreateTileInfo"                                           value="397" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BitmapTextureWinComp"                    opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidBitmapTextureWinCompCreateTileInfo"                                           message="$(string.BitmapTextureWinComp.CreateTile.Info)"                                           />
					<event symbol="LayerVirtualTextureWinCompDestroyInfo"                                        value="398" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerVirtualTextureWinComp"              opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidLayerVirtualTextureWinCompDestroyInfo"                                        message="$(string.LayerVirtualTextureWinComp.Destroy.Info)"                                        />
					<event symbol="LayerCommandListVirtualTextureWinCompSetScrollingLayerParentInternalInfo"     value="399" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerCommandListVirtualTextureWinComp"   opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidLayerCommandListVirtualTextureWinCompSetScrollingLayerParentInternalInfo"     message="$(string.LayerCommandListVirtualTextureWinComp.SetScrollingLayerParentInternal.Info)"     />
					<event symbol="VirtualTextureWinCompOnAppSuspendingInfo"                                     value="400" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureWinCompOnAppSuspendingInfo"                                     message="$(string.VirtualTextureWinComp.OnAppSuspending.Info)"                                     />
					<event symbol="BitmapTextureWinCompOnAppResumingInfo"                                        value="401" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BitmapTextureWinComp"                    opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidBitmapTextureWinCompOnAppResumingInfo"                                        message="$(string.BitmapTextureWinComp.OnAppResuming.Info)"                                        />
					<event symbol="VirtualTextureWinCompOnAppResumingInfo"                                       value="402" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureWinCompOnAppResumingInfo"                                       message="$(string.VirtualTextureWinComp.OnAppResuming.Info)"                                       />
					<event symbol="BitmapTextureWinCompOnAppSuspendingInfo"                                      value="404" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BitmapTextureWinComp"                    opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidBitmapTextureWinCompOnAppSuspendingInfo"                                      message="$(string.BitmapTextureWinComp.OnAppSuspending.Info)"                                      />
					<event symbol="SurfaceLayerBitmapTextureWinCompDrawForTilingInfo"                            value="405" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerBitmapTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSurfaceLayerBitmapTextureWinCompDrawForTilingInfo"                            message="$(string.SurfaceLayerBitmapTextureWinComp.DrawForTiling.Info)"                            />
					<event symbol="SurfaceLayerBitmapTextureWinCompDestroyInfo"                                  value="407" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerBitmapTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSurfaceLayerBitmapTextureWinCompDestroyInfo"                                  message="$(string.SurfaceLayerBitmapTextureWinComp.Destroy.Info)"                                  />
					<event symbol="SurfaceLayerBitmapTextureWinCompCreateInfo"                                   value="409" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerBitmapTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSurfaceLayerBitmapTextureWinCompCreateInfo"                                   message="$(string.SurfaceLayerBitmapTextureWinComp.Create.Info)"                                   />
					<event symbol="CommandListVirtualTextureWinCompOnAppSuspendingInfo"                          value="410" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="CommandListVirtualTextureWinComp"        opcode="win:Info"                                       keywords="BackEnd Texture CommandList"           template="tidCommandListVirtualTextureWinCompOnAppSuspendingInfo"                          message="$(string.CommandListVirtualTextureWinComp.OnAppSuspending.Info)"                          />
					<event symbol="LayerTileManagerSetPrefetchScopeInfo"                                         value="411" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerTileManager"                        opcode="win:Info"                                       keywords="BackEnd Texture LayerTileManager"      template="tidLayerTileManagerSetPrefetchScopeInfo"                                         message="$(string.LayerTileManager.SetPrefetchScope.Info)"                                         />
					<event symbol="VirtualTextureWinCompInvalidateRectInfo"                                      value="412" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureWinCompInvalidateRectInfo"                                      message="$(string.VirtualTextureWinComp.InvalidateRect.Info)"                                      />
					<event symbol="Direct2DTextureWinCompBeginDrawStop"                                          value="413" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Stop"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompBeginDrawStop"                                          message="$(string.Direct2DTextureWinComp.BeginDraw.Stop)"                                          />
					<event symbol="SurfaceLayerSwapChainTextureWinCompCreateInfo"                                value="414" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerSwapChainTextureWinComp"     opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidSurfaceLayerSwapChainTextureWinCompCreateInfo"                                message="$(string.SurfaceLayerSwapChainTextureWinComp.Create.Info)"                                />
					<event symbol="SwapChainTextureWinCompDeviceLossInfo"                                        value="415" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompDeviceLossInfo"                                        message="$(string.SwapChainTextureWinComp.DeviceLoss.Info)"                                        />
					<event symbol="WindowCompositorSetRenderingDeviceFailureInfo"                                value="416" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="WindowCompositor"                        opcode="win:Info"                                       keywords="BackEnd"                               template="tidWindowCompositorSetRenderingDeviceFailureInfo"                                message="$(string.WindowCompositor.SetRenderingDeviceFailure.Info)"                                />
					<event symbol="Direct2DTextureWinCompHandleDrawHrInfo"                                       value="418" version="2" channel="CHANNEL_AIRSPACE" level="win:Warning"       task="Direct2DTextureWinComp"                  opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompHandleDrawHrInfo"                                       message="$(string.Direct2DTextureWinComp.HandleDrawHr.Info)"                                       />
					<event symbol="WindowCompositorCreateInfo"                                                   value="419" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WindowCompositor"                        opcode="win:Info"                                       keywords="BackEnd"                               template="tidWindowCompositorCreateInfo"                                                   message="$(string.WindowCompositor.Create.Info)"                                                   />
					<event symbol="Direct2DTextureWinCompOnSuspendInfo"                                          value="420" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompOnSuspendInfo"                                          message="$(string.Direct2DTextureWinComp.OnSuspend.Info)"                                          />
					<event symbol="Direct2DTextureWinCompEndDrawStart"                                           value="422" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Start"                                      keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompEndDrawStart"                                           message="$(string.Direct2DTextureWinComp.EndDraw.Start)"                                           />
					<event symbol="WindowCompositorDestroyInfo"                                                  value="425" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WindowCompositor"                        opcode="win:Info"                                       keywords="BackEnd"                               template="tidWindowCompositorDestroyInfo"                                                  message="$(string.WindowCompositor.Destroy.Info)"                                                  />
					<event symbol="VirtualTextureWinCompHandleDrawHrInfo"                                        value="426" version="2" channel="CHANNEL_AIRSPACE" level="win:Warning"       task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureWinCompHandleDrawHrInfo"                                        message="$(string.VirtualTextureWinComp.HandleDrawHr.Info)"                                        />
					<event symbol="Direct2DTextureWinCompSetStretchModeInfo"                                     value="427" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompSetStretchModeInfo"                                     message="$(string.Direct2DTextureWinComp.SetStretchMode.Info)"                                     />
					<event symbol="Direct2DTextureWinCompEnsureTileInfo"                                         value="432" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompEnsureTileInfo"                                         message="$(string.Direct2DTextureWinComp.EnsureTile.Info)"                                         />
					<event symbol="VirtualTextureWinCompOnResumeInfo"                                            value="433" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureWinCompOnResumeInfo"                                            message="$(string.VirtualTextureWinComp.OnResume.Info)"                                            />
					<event symbol="SwapChainTextureWinCompOnResumeInfo"                                          value="434" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompOnResumeInfo"                                          message="$(string.SwapChainTextureWinComp.OnResume.Info)"                                          />
					<event symbol="SurfaceLayerSwapChainTextureWinCompDestroyInfo"                               value="436" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerSwapChainTextureWinComp"     opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidSurfaceLayerSwapChainTextureWinCompDestroyInfo"                               message="$(string.SurfaceLayerSwapChainTextureWinComp.Destroy.Info)"                               />
					<event symbol="Direct2DTextureWinCompDeviceLossInfo"                                         value="437" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="Direct2DTextureWinComp"                  opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompDeviceLossInfo"                                         message="$(string.Direct2DTextureWinComp.DeviceLoss.Info)"                                         />
					<event symbol="VirtualTextureWinCompCreateFrontEndInfo"                                      value="440" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureWinCompCreateFrontEndInfo"                                      message="$(string.VirtualTextureWinComp.CreateFrontEnd.Info)"                                      />
					<event symbol="SwapChainTextureWinCompCreateInfo"                                            value="441" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSwapChainTextureWinCompCreateInfo"                                            message="$(string.SwapChainTextureWinComp.Create.Info)"                                            />
					<event symbol="WindowCompositorEnsureWindowCompositionGraphicsDeviceInfo"                    value="443" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WindowCompositor"                        opcode="win:Info"                                       keywords="BackEnd"                               template="tidWindowCompositorEnsureWindowCompositionGraphicsDeviceInfo"                    message="$(string.WindowCompositor.EnsureWindowCompositionGraphicsDevice.Info)"                    />
					<event symbol="VirtualTextureWinCompDestroyFrontEndInfo"                                     value="444" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureWinCompDestroyFrontEndInfo"                                     message="$(string.VirtualTextureWinComp.DestroyFrontEnd.Info)"                                     />
					<event symbol="WindowCompositionGraphicsDeviceSetRenderingDeviceInfo"                        value="445" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="WindowCompositionGraphicsDevice"         opcode="win:Info"                                       keywords="BackEnd"                               template="tidWindowCompositionGraphicsDeviceSetRenderingDeviceInfo"                        message="$(string.WindowCompositionGraphicsDevice.SetRenderingDevice.Info)"                        />
					<event symbol="Direct2DTextureWinCompEndDrawStop"                                            value="448" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Stop"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompEndDrawStop"                                            message="$(string.Direct2DTextureWinComp.EndDraw.Stop)"                                            />
					<event symbol="SwapChainTextureWinCompDestroyInfo"                                           value="456" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSwapChainTextureWinCompDestroyInfo"                                           message="$(string.SwapChainTextureWinComp.Destroy.Info)"                                           />
					<event symbol="Direct2DTextureWinCompBeginDrawStart"                                         value="457" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Start"                                      keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompBeginDrawStart"                                         message="$(string.Direct2DTextureWinComp.BeginDraw.Start)"                                         />
					<event symbol="SurfaceLayerSwapChainTextureWinCompCompositionSurfaceChangedInfo"             value="458" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SurfaceLayerSwapChainTextureWinComp"     opcode="win:Info"                                       keywords="BackEnd Texture LayerTexture"          template="tidSurfaceLayerSwapChainTextureWinCompCompositionSurfaceChangedInfo"             message="$(string.SurfaceLayerSwapChainTextureWinComp.CompositionSurfaceChanged.Info)"             />
					<event symbol="Direct2DTextureWinCompResizeInfo"                                             value="459" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompResizeInfo"                                             message="$(string.Direct2DTextureWinComp.Resize.Info)"                                             />
					<event symbol="VirtualTextureWinCompDeviceLossInfo"                                          value="460" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureWinCompDeviceLossInfo"                                          message="$(string.VirtualTextureWinComp.DeviceLoss.Info)"                                          />
					<event symbol="SwapChainTextureWinCompOnAppSuspendingInfo"                                   value="461" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidSwapChainTextureWinCompOnAppSuspendingInfo"                                   message="$(string.SwapChainTextureWinComp.OnAppSuspending.Info)"                                   />
					<event symbol="VirtualTextureWinCompOnSuspendInfo"                                           value="464" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureWinCompOnSuspendInfo"                                           message="$(string.VirtualTextureWinComp.OnSuspend.Info)"                                           />
					<event symbol="SwapChainTextureWinCompHandleDeviceHrInfo"                                    value="466" version="2" channel="CHANNEL_AIRSPACE" level="win:Warning"       task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompHandleDeviceHrInfo"                                    message="$(string.SwapChainTextureWinComp.HandleDeviceHr.Info)"                                    />
					<event symbol="Direct2DTextureWinCompOnResumeInfo"                                           value="469" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTextureWinComp"                  opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidDirect2DTextureWinCompOnResumeInfo"                                           message="$(string.Direct2DTextureWinComp.OnResume.Info)"                                           />
					<event symbol="SwapChainTextureWinCompDestroyFrontEndInfo"                                   value="470" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompDestroyFrontEndInfo"                                   message="$(string.SwapChainTextureWinComp.DestroyFrontEnd.Info)"                                   />
					<event symbol="SwapChainTextureWinCompOnSuspendInfo"                                         value="472" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompOnSuspendInfo"                                         message="$(string.SwapChainTextureWinComp.OnSuspend.Info)"                                         />
					<event symbol="Direct2DTextureWinCompBeginDrawNullRenderTargetInfo"                          value="473" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="Direct2DTextureWinComp"                  opcode="win:Info"                                       keywords="FrontEnd Texture NullRenderTarget"     template="tidDirect2DTextureWinCompBeginDrawNullRenderTargetInfo"                          message="$(string.Direct2DTextureWinComp.BeginDrawNullRenderTarget.Info)"                          />
					<event symbol="SwapChainTextureWinCompCreateFrontEndInfo"                                    value="474" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompCreateFrontEndInfo"                                    message="$(string.SwapChainTextureWinComp.CreateFrontEnd.Info)"                                    />
					<event symbol="ScrollingLayerWinCompOnPointerWheelChangedInfo"                               value="475" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompOnPointerWheelChangedInfo"                               message="$(string.ScrollingLayerWinComp.OnPointerWheelChanged.Info)"                               />
					<event symbol="ScrollingLayerWinCompTryRedirectForManipulationInfo"                          value="476" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompTryRedirectForManipulationInfo"                          message="$(string.ScrollingLayerWinComp.TryRedirectForManipulation.Info)"                          />
					<event symbol="LayerWinCompUpdateBorderLayoutInfo"                                           value="477" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="LayerWinComp"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidLayerWinCompUpdateBorderLayoutInfo"                                           message="$(string.LayerWinComp.UpdateBorderLayout.Info)"                                           />
					<event symbol="ScrollingLayerWinCompSetupInteractionTrackerInfo"                             value="478" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompSetupInteractionTrackerInfo"                             message="$(string.ScrollingLayerWinComp.SetupInteractionTracker.Info)"                             />
					<event symbol="ScrollingLayerClearZoomSnapPointsInfo"                                        value="479" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerClearZoomSnapPointsInfo"                                        message="$(string.ScrollingLayer.ClearZoomSnapPoints.Info)"                                        />
					<event symbol="ScrollingLayerSetRegularSnapPointsInfo"                                       value="480" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerSetRegularSnapPointsInfo"                                       message="$(string.ScrollingLayer.SetRegularSnapPoints.Info)"                                       />
					<event symbol="ScrollingLayerSetSnapPointsTypeInfo"                                          value="481" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerSetSnapPointsTypeInfo"                                          message="$(string.ScrollingLayer.SetSnapPointsType.Info)"                                          />
					<event symbol="ScrollingLayerSetIrregularSnapPointsInfo"                                     value="482" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerSetIrregularSnapPointsInfo"                                     message="$(string.ScrollingLayer.SetIrregularSnapPoints.Info)"                                     />
					<event symbol="ScrollingLayerAddZoomSnapPointInfo"                                           value="483" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerAddZoomSnapPointInfo"                                           message="$(string.ScrollingLayer.AddZoomSnapPoint.Info)"                                           />
					<event symbol="TileWinCompCreateSurfaceFailureInfo"                                          value="484" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="TileWinComp"                             opcode="win:Info"                                       keywords="FrontEnd Tile"                         template="tidTileWinCompCreateSurfaceFailureInfo"                                          message="$(string.TileWinComp.CreateSurfaceFailure.Info)"                                          />
					<event symbol="TileWinCompEndDrawFailureInfo"                                                value="485" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="TileWinComp"                             opcode="win:Info"                                       keywords="FrontEnd Tile"                         template="tidTileWinCompEndDrawFailureInfo"                                                message="$(string.TileWinComp.EndDrawFailure.Info)"                                                />
					<event symbol="CompositorWinCompIsEnabledInfo"                                               value="486" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="BackEnd Initialization"                template="tidCompositorWinCompIsEnabledInfo"                                               message="$(string.Compositor.WinCompIsEnabled.Info)"                                               />
					<event symbol="SwapChainTextureWinCompBeginDrawAppSuspendedInfo"                             value="487" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompBeginDrawAppSuspendedInfo"                             message="$(string.SwapChainTextureWinComp.BeginDrawAppSuspended.Info)"                             />
					<event symbol="SwapChainTextureWinCompBeginDrawEnsureResourcesInfo"                          value="488" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompBeginDrawEnsureResourcesInfo"                          message="$(string.SwapChainTextureWinComp.BeginDrawEnsureResources.Info)"                          />
					<event symbol="SwapChainTextureWinCompBeginDrawWrongThreadInfo"                              value="489" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompBeginDrawWrongThreadInfo"                              message="$(string.SwapChainTextureWinComp.BeginDrawWrongThread.Info)"                              />
					<event symbol="SwapChainTextureWinCompBeginDrawNonRenderTextureInfo"                         value="490" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompBeginDrawNonRenderTextureInfo"                         message="$(string.SwapChainTextureWinComp.BeginDrawNonRenderTexture.Info)"                         />
					<event symbol="SwapChainTextureWinCompBeginDrawNestedDrawInfo"                               value="491" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="SwapChainTextureWinComp"                 opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidSwapChainTextureWinCompBeginDrawNestedDrawInfo"                               message="$(string.SwapChainTextureWinComp.BeginDrawNestedDraw.Info)"                               />
					<event symbol="VirtualTextureBaseWinCompOnAppResumingInfo"                                   value="492" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureBaseWinComp"               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureBaseWinCompOnAppResumingInfo"                                   message="$(string.VirtualTextureBaseWinComp.OnAppResuming.Info)"                                   />
					<event symbol="VirtualTextureBaseWinCompOnAppSuspendingInfo"                                 value="493" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureBaseWinComp"               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureBaseWinCompOnAppSuspendingInfo"                                 message="$(string.VirtualTextureBaseWinComp.OnAppSuspending.Info)"                                 />
					<event symbol="VirtualTextureBaseWinCompInvalidateRectInfo"                                  value="494" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureBaseWinComp"               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureBaseWinCompInvalidateRectInfo"                                  message="$(string.VirtualTextureBaseWinComp.InvalidateRect.Info)"                                  />
					<event symbol="VirtualTextureBaseWinCompResizeInfo"                                          value="495" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureBaseWinComp"               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureBaseWinCompResizeInfo"                                          message="$(string.VirtualTextureBaseWinComp.Resize.Info)"                                          />
					<event symbol="VirtualTextureBaseWinCompSetPrefetchSizeInfo"                                 value="496" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTextureBaseWinComp"               opcode="win:Info"                                       keywords="BackEnd Texture"                       template="tidVirtualTextureBaseWinCompSetPrefetchSizeInfo"                                 message="$(string.VirtualTextureBaseWinComp.SetPrefetchSize.Info)"                                 />
					<event symbol="ScrollingLayerWinCompChainingSupportChangedInfo"                              value="497" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompChainingSupportChangedInfo"                              message="$(string.ScrollingLayerWinComp.ChainingSupportChanged.Info)"                              />
					<event symbol="ScrollingLayerWinCompValuesChangedStart"                                      value="498" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Start"                                      keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompValuesChangedStart"                                      message="$(string.ScrollingLayerWinComp.ValuesChanged.Start)"                                      />
					<event symbol="ScrollingLayerWinCompRequestIgnoredInfo"                                      value="499" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompRequestIgnoredInfo"                                      message="$(string.ScrollingLayerWinComp.RequestIgnored.Info)"                                      />
					<event symbol="ScrollingLayerWinCompInertiaStateEnteredInfo"                                 value="500" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompInertiaStateEnteredInfo"                                 message="$(string.ScrollingLayerWinComp.InertiaStateEntered.Info)"                                 />
					<event symbol="ScrollingLayerWinCompApplyScrollInfo"                                         value="501" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompApplyScrollInfo"                                         message="$(string.ScrollingLayerWinComp.ApplyScroll.Info)"                                         />
					<event symbol="ScrollingLayerWinCompValuesChangedWorkaroundInfo"                             value="502" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompValuesChangedWorkaroundInfo"                             message="$(string.ScrollingLayerWinComp.ValuesChangedWorkaround.Info)"                             />
					<event symbol="ScrollingLayerWinCompValuesChangedStop"                                       value="503" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Stop"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompValuesChangedStop"                                       message="$(string.ScrollingLayerWinComp.ValuesChanged.Stop)"                                       />
					<event symbol="ScrollingLayerWinCompRejiggerStop"                                            value="504" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Stop"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompRejiggerStop"                                            message="$(string.ScrollingLayerWinComp.Rejigger.Stop)"                                            />
					<event symbol="ScrollingLayerWinCompInteractingStateEnteredInfo"                             value="505" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompInteractingStateEnteredInfo"                             message="$(string.ScrollingLayerWinComp.InteractingStateEntered.Info)"                             />
					<event symbol="ScrollingLayerWinCompRejiggerStart"                                           value="506" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Start"                                      keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompRejiggerStart"                                           message="$(string.ScrollingLayerWinComp.Rejigger.Start)"                                           />
					<event symbol="ScrollingLayerWinCompUpdateViewportPositionInfo"                              value="507" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompUpdateViewportPositionInfo"                              message="$(string.ScrollingLayerWinComp.UpdateViewportPosition.Info)"                              />
					<event symbol="ScrollingLayerWinCompIdleStateEnteredInfo"                                    value="508" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompIdleStateEnteredInfo"                                    message="$(string.ScrollingLayerWinComp.IdleStateEntered.Info)"                                    />
					<event symbol="ScrollingLayerWinCompCustomAnimationStateEnteredInfo"                         value="509" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompCustomAnimationStateEnteredInfo"                         message="$(string.ScrollingLayerWinComp.CustomAnimationStateEntered.Info)"                         />
					<event symbol="ScrollingLayerUpdateMinMaxPositionInfo"                                       value="510" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayer"                          opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerUpdateMinMaxPositionInfo"                                       message="$(string.ScrollingLayer.UpdateMinMaxPosition.Info)"                                       />
					<event symbol="VirtualTextureFrontEndWin32BeginDrawGdiInfo"                                  value="511" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidVirtualTextureFrontEndWin32BeginDrawGdiInfo"                                  message="$(string.VirtualTexture.FrontEndWin32BeginDrawGdi.Info)"                                  />
					<event symbol="GdiTextureBeginDrawNullHDCInfo"                                               value="512" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="GdiTexture"                              opcode="win:Info"                                       keywords="FrontEnd Texture NullHDC"              template="tidNullRenderTargetInfo"                                                         message="$(string.GdiTexture.BeginDrawNullHDC.Info)"                                               />
					<event symbol="VirtualTextureBeginDrawNullHDCInfo"                                           value="513" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture NullHDC"              template="tidNullRenderTargetInfo"                                                         message="$(string.VirtualTexture.BeginDrawNullHDC.Info)"                                           />
					<event symbol="VirtualTextureBeginDrawNullRenderTargetInfo"                                  value="514" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="VirtualTexture"                          opcode="win:Info"                                       keywords="FrontEnd Texture NullRenderTarget"     template="tidNullRenderTargetInfo"                                                         message="$(string.VirtualTexture.BeginDrawNullRenderTarget.Info)"                                  />
					<event symbol="ArcTextureAppleBeginDrawNullRenderTargetInfo"                                 value="515" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ArcTextureApple"                         opcode="win:Info"                                       keywords="FrontEnd Texture NullRenderTarget"     template="tidNullRenderTargetInfo"                                                         message="$(string.ArcTextureApple.BeginDrawNullRenderTarget.Info)"                                 />
					<event symbol="XamlAnimationSchedulerKeyframeScheduled"                                      value="516" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidSchedulerKeyframe"                                                            />
					<event symbol="ForgetAnimationTracker"                                                       value="517" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidAnimationTracker"                                                             />
					<event symbol="AnimationTrackerDestroyed"                                                    value="518" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidAnimationTracker"                                                             />
					<event symbol="AnimationTrackerTrackingInstance"                                             value="519" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation Timing"                      template="tidAnimationTrackerTracking"                                                     />
					<event symbol="TileWinCompCreateCompositionSurfaceInfo"                                      value="520" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="TileWinComp"                             opcode="win:Info"                                       keywords="FrontEnd Tile"                         template="tidTileWinCompCreateCompositionSurfaceInfo"                                      message="$(string.TileWinComp.CreateCompositionSurface.Info)"                                      />
					<event symbol="LayerHostWin32SetDirectManipulationActiveInfo"                                value="521" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="LayerHostWin32"                          opcode="win:Info"                                       keywords="FrontEnd DirectManipulation"           template="tidLayerHostWin32SetDirectManipulationActiveInfo"                                message="$(string.LayerHostWin32.SetDirectManipulationActive.Info)"                                />
					<event symbol="ScrollingLayerWinCompValuesChangedRequestIdInfo"                              value="522" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerWinCompValuesChangedRequestIdInfo"                              message="$(string.ScrollingLayerWinComp.ValuesChangedRequestId.Info)"                              />
					<event symbol="BackEndLayerPropogatevirtualPerimeterMismatchInfo"                            value="523" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerPropogatevirtualPerimeterMismatchInfo"                            message="$(string.BackEndLayer.PropogatevirtualPerimeterMismatch.Info)"                            />
					<event symbol="BackEndLayerPropogateVirtualizedRectMismatchInfoInfo"                         value="524" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidBackEndLayerPropogateVirtualizedRectMismatchInfoInfo"                         message="$(string.BackEndLayer.PropogateVirtualizedRectMismatchInfo.Info)"                         />
					<event symbol="ScrollingLayerWinCompTryUpdatePositionWithAnimationInfo"                      value="526" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerWinCompTryUpdatePositionWithAnimationInfo"                      message="$(string.ScrollingLayerWinComp.TryUpdatePositionWithAnimation.Info)"                      />
					<event symbol="ScrollingLayerWinCompTryUpdateScaleWithAnimationInfo"                         value="528" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerWinCompTryUpdateScaleWithAnimationInfo"                         message="$(string.ScrollingLayerWinComp.TryUpdateScaleWithAnimation.Info)"                         />
					<event symbol="ScrollingLayerWinCompTryUpdatePositionWithoutClampingInfo"                    value="529" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerWinCompTryUpdatePositionWithoutClampingInfo"                    message="$(string.ScrollingLayerWinComp.TryUpdatePositionWithoutClamping.Info)"                    />
					<event symbol="ScrollingLayerWinCompTryUpdateScaleInfo"                                      value="531" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer Scrolling"               template="tidScrollingLayerWinCompTryUpdateScaleInfo"                                      message="$(string.ScrollingLayerWinComp.TryUpdateScale.Info)"                                      />
					<event symbol="ScrollingLayerWinCompUpdatePlatformCanvasSizeInfo"                            value="533" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompUpdatePlatformCanvasSizeInfo"                            message="$(string.ScrollingLayerWinComp.UpdatePlatformCanvasSize.Info)"                            />
					<event symbol="SceneCreateBitmapTextureExceededMaxDimensionInfo"                             value="534" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="Scene"                                   opcode="win:Info"                                       keywords="Texture MaxTextureDimension"           template="tidExceededMaxDimensionInfo"                                                     />
					<event symbol="BitmapTextureResizeExceededMaxDimensionInfo"                                  value="535" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="Direct2DTexture"                         opcode="win:Info"                                       keywords="Texture MaxTextureDimension"           template="tidResizeExceededMaxDimensionInfo"                                               />
					<event symbol="TextureBeginDrawNullRenderTargetInfo"                                         value="536" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Direct2DTexture"                         opcode="win:Info"                                       keywords="FrontEnd Texture NullRenderTarget"     template="tidNullRenderTargetInfo"                                                         />
					<event symbol="ScrollingLayerWinCompApplyScrollOffsetsAdjustedInfo"                          value="537" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidScrollingLayerWinCompApplyScrollOffsetsAdjustedInfo"                          message="$(string.ScrollingLayerWinComp.ApplyScrollOffsetsAdjusted.Info)"                          />
					<event symbol="TileWinCompSurfaceNotCoveredByInitialDrawInfo"                                value="538" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="TileWinComp"                             opcode="win:Info"                                       keywords="FrontEnd Tile"                         template="tidTileWinCompSurfaceNotCoveredByInitialDrawInfo"                                message="$(string.TileWinComp.SurfaceNotCoveredByInitialDraw.Info)"                                />
					<event symbol="BitmapTextureInvalidSetStretchModeUsage"                                      value="539" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="BitmapTexture"                           opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidBitmapTextureInvalidSetStretchModeUsage"                                      message="$(string.BitmapTexture.InvalidSetStretchModeUsage)"                                       />
					<event symbol="CopyBitmapTextureInvalidUsage"                                                value="540" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="BitmapTexture"                           opcode="win:Info"                                       keywords="FrontEnd Texture"                      template="tidCopyBitmapTextureInvalidUsage"                                                message="$(string.BitmapTexture.InvalidCopyBitmapTextureUsage)"                                    />
					<event symbol="ChannelActivityInfo"                                                          value="541" version="2" channel="CHANNEL_AIRSPACE" level="win:Verbose"       task="Channel"                                 opcode="win:Info"                                       keywords="Channel"                               template="tidChannelActivityInfo"                                                          message="$(string.Channel.ChannelActivity.Info)"                                                   />
					<event symbol="LayerApplyIntermediateVirtualTextureUntilContentReady"                        value="542" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="BackEndLayer"                            opcode="win:Info"                                       keywords="BackEnd Texture Layer"                 template="tidLayerApplyIntermediateVirtualTextureUntilContentReady"                        message="$(string.Layer.ApplyIntermediateVirtualTextureUntilContentReady)"                         />
					<event symbol="ChannelActivityInfoExtended"                                                  value="543" version="2" channel="CHANNEL_AIRSPACE" level="win:Verbose"       task="Channel"                                 opcode="win:Info"                                       keywords="Channel"                               template="tidChannelActivityInfo"                                                          message="$(string.Channel.ChannelActivityExtended.Info)"                                           />
					<event symbol="WinCompAnimationSchedulerScrollAnimationInfo"                                 value="544" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="Animation"                             template="tidWinCompAnimationSchedulerScrollAnimationInfo"                                 message="$(string.WinCompAnimationScheduler.ScrollAnimation.Info)"                                 />
					<event symbol="AbnormalStateEnteredInfo"                                                     value="545" version="2" channel="CHANNEL_AIRSPACE" level="win:Error"         task="Compositor"                              opcode="win:Info"                                       keywords="Exception Channel Memory"              template="tidExceptionAbnormalStateEnteredInfo"                                            message="$(string.Exception.AbnormalStateEntered.Info)"                                            />
					<event symbol="PointerDownInfo"                                                              value="546" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Layer"                        template="tidInputProcessingPointerInfo"                                                   message="$(string.InputProcessing.PointerDown.Info)"                                               />
					<event symbol="PointerUpInfo"                                                                value="547" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Layer"                        template="tidInputProcessingPointerInfo"                                                   message="$(string.InputProcessing.PointerUp.Info)"                                                 />
					<event symbol="SetContactInfo"                                                               value="548" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Layer"                        template="tidInputProcessingPointerInfo"                                                   message="$(string.InputProcessing.SetContact.Info)"                                                />
					<event symbol="ActivateScrollingInfo"                                                        value="549" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="FrontEnd Layer"                        template="tidInputProcessingPointerInfo"                                                   message="$(string.InputProcessing.ActivateScrolling.Info)"                                         />
					<event symbol="TryRedirectForManipulationInfo"                                               value="550" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidInputProcessingPointerInfo"                                                   message="$(string.InputProcessing.TryRedirectInputForManipulation.Info)"                           />
					<event symbol="CancelInteractionTracker"                                                     value="551" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidInputProcessingPointerInfo"                                                   message="$(string.InputProcessing.TryRedirectInputForManipulation.Info)"                           />
					<event symbol="ResumeInteractionTracker"                                                     value="552" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidInputProcessingPointerInfo"                                                   message="$(string.InputProcessing.TryRedirectInputForManipulation.Info)"                           />
					<event symbol="VirtualTextureOptimizerTileLog"                                               value="553" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="ScrollingLayerWinComp"                   opcode="win:Info"                                       keywords="BackEnd Layer"                         template="tidVirtualTextureOptimizerTileLog"                                               message="$(string.TileWinComp.VirtualTextureOptimizerTileLog.Info)"                                />
					<event symbol="WinCompVisualCaptureWait"                                                     value="554" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="FrontEnd BackEnd Channel"              template="tidWinCompVisualCaptureWait"                                                     message="$(string.Channel.WinCompVisualCaptureWait.Info)"                                          />
					<event symbol="WinCompBlockingCommandWait"                                                   value="555" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="FrontEnd BackEnd Channel"              template="tidWinCompBlockingCommandWait"                                                   message="$(string.Channel.WinCompBlockingCommandWait.Info)"                                        />
					<event symbol="InitialSceneBatch"                                                            value="556" version="2" channel="CHANNEL_AIRSPACE" level="win:Informational" task="Compositor"                              opcode="win:Info"                                       keywords="FrontEnd Initialization"               template="tidInitialSceneBatch"                                                            />
				</events>
				<!--  Available Event IDs: 1+ -->
				<channels>
					<channel name="AirSpaceChannel" chid="CHANNEL_AIRSPACE" symbol="CHANNEL_AIRSPACE" type="Analytic" enabled="false" isolation="Application" />
				</channels>
				<tasks>
					<task name="Compositor"                              symbol="TASK_COMPOSITOR"                              value="1"  eventGUID="{991F01E2-AF01-4c27-8F15-024A190FEB4B}" />
					<task name="DirectX"                                 symbol="TASK_DIRECTX"                                 value="2"  eventGUID="{4D745CEC-1409-4817-A135-A20EE7A94E4F}" />
					<task name="Channel"                                 symbol="TASK_CHANNEL"                                 value="3"  eventGUID="{B6739A33-69E2-4c8e-BFEE-F9DCA06E75B5}" />
					<task name="AirSpy"                                  symbol="TASK_AIRSPY"                                  value="4"  eventGUID="{DD9DA8F5-33BF-4b47-84EA-FA1F6D3C2A5A}" />
					<task name="RenderThread"                            symbol="TASK_RENDERTHREAD"                            value="5"  eventGUID="{AED4C3FB-8A63-4629-B382-467ECE86B494}" />
					<task name="UpdateTextures"                          symbol="TASK_UPDATETEXTURES"                          value="6"  eventGUID="{3799B7F1-0468-4e98-ACB9-9BA9D49DD3DA}" />
					<task name="VirtualTexture"                          symbol="TASK_VIRTUALTEXTURE"                          value="7"  eventGUID="{666D58CE-2B51-48CC-B86C-AB064ED081CC}" />
					<task name="CommandList"                             symbol="TASK_COMMANDLIST"                             value="8"  eventGUID="{8A39A91A-DEEE-4B02-9CF9-7C8EC13E30BD}" />
					<task name="CommandListComposite"                    symbol="TASK_COMMANDLISTCOMPOSITE"                    value="9"  eventGUID="{E67CD8C2-9DCF-441F-AB6E-6D8E84211EFF}" />
					<task name="XamlDrawableSurface"                     symbol="TASK_XamlDrawableSurface"                     value="10" eventGUID="{CEE9C0C6-5318-47DC-94C3-1A214813E5A8}" />
					<task name="XamlVirtualizedSurface"                  symbol="TASK_XAMLVIRTUALIZEDSURFACE"                  value="11" eventGUID="{699C59FA-6C51-4BE5-A1CD-1D995D2E799B}" />
					<task name="Layer"                                   symbol="TASK_LAYER"                                   value="12" eventGUID="{43F0595F-9415-4C22-B666-7F733359F323}" />
					<task name="ScrollingLayer"                          symbol="TASK_SCROLLINGLAYER"                          value="13" eventGUID="{FDDDF65B-9F76-4453-B175-DCC5CA1273ED}" />
					<task name="PrefetchScope"                           symbol="TASK_PREFETCHSCOPE"                           value="14" eventGUID="{CB2B71D8-A0A2-4A2C-B6F1-463B673B0306}" />
					<task name="Direct2DTexture"                         symbol="TASK_DIRECT2DTEXTURE"                         value="15" eventGUID="{213B2111-C8F4-4670-BF43-8425A143043F}" />
					<task name="CommandListVirtualTexture"               symbol="TASK_COMMANDLISTVIRTUALTEXTURE"               value="16" eventGUID="{BA9D06A0-E768-46B6-A66D-D67A7B05A0E9}" />
					<task name="VSISTile"                                symbol="TASK_VSISTILE"                                value="17" eventGUID="{EBF3297D-ECD7-4F0E-8D1C-045BEF3803EE}" />
					<task name="SceneD"                                  symbol="TASK_SCENED"                                  value="18" eventGUID="{B7215280-EC0F-4FC5-BA69-B526E7D0C4D9}" />
					<task name="LayerHostD"                              symbol="TASK_LAYERHOSTD"                              value="19" eventGUID="{ED780EAF-F579-4FB7-B12D-D6E50C4C7288}" />
					<task name="SurfaceManager"                          symbol="TASK_SURFACEMANAGER"                          value="20" eventGUID="{DDD7BE09-26AD-4F77-80C6-247771812AC7}" />
					<task name="WetInkTexture"                           symbol="TASK_WETINKTEXTURE"                           value="21" eventGUID="{705DF929-21C0-4BD4-9368-1E684309D06D}" />
					<task name="Scene"                                   symbol="TASK_SCENE"                                   value="22" eventGUID="{D94CD4E7-9E49-4F79-A03C-D3E92BAFE242}" />
					<task name="LayerHostI"                              symbol="TASK_LAYERHOSTI"                              value="23" eventGUID="{C0B8B8F2-5BD4-48D0-B35F-264AD01D865C}" />
					<task name="SceneI"                                  symbol="TASK_SCENEI"                                  value="24" eventGUID="{3C12C75B-5E73-48B6-96A2-25F56900D881}" />
					<task name="XamlHostingLayer"                        symbol="TASK_XAMLHOSTINGLAYER"                        value="25" eventGUID="{21217C5C-7D04-4B37-9036-2B1DE7A6B080}" />
					<task name="WetInkSwapChainPanel"                    symbol="TASK_WETINKSWAPCHAINPANEL"                    value="26" eventGUID="{07CEDF52-836A-440E-A1A5-D842F8A4630F}" />
					<task name="BasicSwapChainPanel"                     symbol="TASK_BASICSWAPCHAINPANEL"                     value="27" eventGUID="{BFBC59E2-0660-4893-AB80-2CF7118FB80E}" />
					<task name="XamlMultithreadNativeSurfaceOffThread"   symbol="TASK_XAMLMULTITHREADNATIVESURFACEOFFTHREAD"   value="28" eventGUID="{CE6E77BE-669A-4FD0-A4A9-52933F7AE028}" />
					<task name="XamlMultithreadNativeSurface"            symbol="TASK_XAMLMULTITHREADNATIVESURFACE"            value="29" eventGUID="{AB59D1C1-6088-4D08-8D54-527AA3EF1783}" />
					<task name="XamlMultithreadNativeSurfaceUI"          symbol="TASK_XAMLMULTITHREADNATIVESURFACEUI"          value="30" eventGUID="{3510B366-BE21-441B-B8F8-1EB7D8011052}" />
					<task name="InteractionInstance"                     symbol="TASK_INTERACTIONINSTANCE"                     value="31" eventGUID="{0BC674FF-6450-4B6C-8B91-8E6044AE6BCE}" />
					<task name="InputProcessor"                          symbol="TASK_INPUTPROCESSOR"                          value="32" eventGUID="{86A52461-1317-4A0B-BFF7-CE485B53DCCE}" />
					<task name="CommandListRasterizeWork"                symbol="TASK_COMMANDLISTRASTERIZEWORK"                value="33" eventGUID="{F124D1A2-7E39-4A2B-84E5-BDDDFB218D10}" />
					<task name="CommandListRasterizer"                   symbol="TASK_COMMANDLISTRASTERIZER"                   value="34" eventGUID="{26C872A1-1D1C-4B3F-95F9-F006C1558FDD}" />
					<task name="VSISTiler"                               symbol="TASK_VSISTILER"                               value="35" eventGUID="{AF6211C8-B325-410F-A6E7-5B032955E235}" />
					<task name="XamlMultithreadDrawableSurfaceOffThread" symbol="TASK_XAMLMULTITHREADDRAWABLESURFACEOFFTHREAD" value="36" eventGUID="{D2F633F6-B613-41FB-A9F9-61D29AAF4E97}" />
					<task name="XamlVirtualSurface"                      symbol="TASK_XAMLVIRTUALSURFACE"                      value="37" eventGUID="{7A898A88-DB9E-45B5-8A9E-646FE08608AD}" />
					<task name="XamlMultithreadDrawableSurface"          symbol="TASK_XAMLMULTITHREADDRAWABLESURFACE"          value="38" eventGUID="{B70CDB2E-19BA-47E3-ABB7-5FEBDB3FF925}" />
					<task name="XamlSurface"                             symbol="TASK_XAMLSURFACE"                             value="39" eventGUID="{4324B6EF-41C7-46A4-9BC3-41B8489ABC0E}" />
					<task name="XamlMultithreadVirtualSurface"           symbol="TASK_XAMLMULTITHREADVIRTUALSURFACE"           value="40" eventGUID="{A0B393C8-C5B8-4441-B5A2-AAA6BAD99D16}" />
					<task name="BitmapAllocator"                         symbol="TASK_BITMAPALLOCATOR"                         value="41" eventGUID="{6523D91F-6888-4F42-8EEA-0B874486D2D8}" />
					<task name="MemoryHelper"                            symbol="TASK_MEMORYHELPER"                            value="42" eventGUID="{E5914B98-B9B7-409F-B149-65105D1D4187}" />
					<task name="BackEndLayer"                            symbol="TASK_BACKENDLAYER"                            value="43" eventGUID="{EA7006CE-6A36-4C1B-ADD9-6DE0A319BDB7}" />
					<task name="ScrollingLayerCanvas"                    symbol="TASK_SCROLLINGLAYERCANVAS"                    value="44" eventGUID="{6C319A3C-33B0-46F4-B2B6-EEDAA22560B3}" />
					<task name="AirSpace"                                symbol="TASK_AIRSPACE"                                value="45" eventGUID="{37536B99-76B8-46D1-8FAF-7E61426693A8}" />
					<task name="DirectXDeviceResources"                  symbol="TASK_DIRECTXDEVICERESOURCES"                  value="46" eventGUID="{44F23BDC-BBAD-475D-8CA1-4D17E48826A2}" />
					<task name="Direct2dDeviceResources"                 symbol="TASK_DIRECT2DDEVICERESOURCES"                 value="47" eventGUID="{9E2E4A67-4391-43AD-A180-A5342E470E1C}" />
					<task name="VirtualTextureWinComp"                   symbol="TASK_VIRTUALTEXTUREWINCOMP"                   value="48" eventGUID="{50EC6F7E-0957-485D-AE2F-7524AFB2E0B7}" />
					<task name="CommandListVirtualTextureWinComp"        symbol="TASK_COMMANDLISTVIRTUALTEXTUREWINCOMP"        value="49" eventGUID="{C4F96E08-8691-4569-A717-1743DA61C82E}" />
					<task name="LayerTileManager"                        symbol="TASK_LAYERTILEMANAGER"                        value="50" eventGUID="{70A8211D-38BA-4A4C-90E0-C2B28B2F78D0}" />
					<task name="LayerCommandListVirtualTextureWinComp"   symbol="TASK_LAYERCOMMANDLISTVIRTUALTEXTUREWINCOMP"   value="51" eventGUID="{F350B0C4-E940-492A-AE12-CE6F8E85A327}" />
					<task name="ScrollingLayerWinComp"                   symbol="TASK_SCROLLINGLAYERWINCOMP"                   value="52" eventGUID="{45F2B57A-BE70-46A6-B4B0-1C6AD1C8005C}" />
					<task name="TileWinComp"                             symbol="TASK_TILEWINCOMP"                             value="53" eventGUID="{C337CCD2-ABF3-40C5-82B2-056FBD67A45A}" />
					<task name="CommandListRasterizerWorkItem"           symbol="TASK_COMMANDLISTRASTERIZERWORKITEM"           value="54" eventGUID="{0A436A32-3C97-46FA-A0A2-AC73929DF022}" />
					<task name="SurfaceLayerBitmapTextureWinComp"        symbol="TASK_SURFACELAYERBITMAPTEXTUREWINCOMP"        value="55" eventGUID="{7CBC9D45-AA23-4693-926D-9D6F6EE2D793}" />
					<task name="TileManagerWinComp"                      symbol="TASK_TILEMANAGERWINCOMP"                      value="56" eventGUID="{9BCAD495-45C1-4175-BE55-801DFABF5871}" />
					<task name="BitmapTextureWinComp"                    symbol="TASK_BITMAPTEXTUREWINCOMP"                    value="57" eventGUID="{6EC83FA3-5C42-4078-BD71-4E4523C13EAE}" />
					<task name="CommandListPlayback"                     symbol="TASK_COMMANDLISTPLAYBACK"                     value="58" eventGUID="{0AD8C519-E0E4-4323-A23A-81559A5F7303}" />
					<task name="LayerVirtualTextureWinComp"              symbol="TASK_LAYERVIRTUALTEXTUREWINCOMP"              value="59" eventGUID="{1F3952EC-4AB1-4BC0-AC69-530F7E3AB7CA}" />
					<task name="Direct2DTextureWinComp"                  symbol="TASK_DIRECT2DTEXTUREWINCOMP"                  value="60" eventGUID="{C1064D5E-2CED-4398-98D2-41E37576B539}" />
					<task name="SurfaceLayerSwapChainTextureWinComp"     symbol="TASK_SURFACELAYERSWAPCHAINTEXTUREWINCOMP"     value="61" eventGUID="{9A6E6F9A-8D44-4F72-A959-2479D437BE8F}" />
					<task name="SwapChainTextureWinComp"                 symbol="TASK_SWAPCHAINTEXTUREWINCOMP"                 value="62" eventGUID="{AA78C826-5A96-4341-A8E1-6F27915D6E28}" />
					<task name="WindowCompositor"                        symbol="TASK_WINDOWCOMPOSITOR"                        value="63" eventGUID="{414A3ABF-B128-42F2-ADC1-ED8291B4CB9F}" />
					<task name="TileManager"                             symbol="TASK_TILEMANAGER"                             value="64" eventGUID="{2320C204-67D2-47F9-AD26-1079A91FEAD5}" />
					<task name="WindowCompositionGraphicsDevice"         symbol="TASK_WINDOWCOMPOSITIONGRAPHICSDEVICE"         value="65" eventGUID="{F8E081BF-7110-4E38-B563-D4FCCC74C242}" />
					<task name="TileSurfaceEndDrawBatchState"            symbol="TASK_TILESURFACEENDDRAWBATCHSTATE"            value="66" eventGUID="{829A031E-1AAA-4A60-A954-56715BD9B890}" />
					<task name="LayerWinComp"                            symbol="TASK_LAYERWINCOMP"                            value="67" eventGUID="{1E61F2C4-4814-48D0-8436-C6DC83925581}" />
					<task name="VirtualTextureBaseWinComp"               symbol="TASK_VIRTUALTEXTUREBASEWINCOMP"               value="68" eventGUID="{93DE4A8E-07BD-4399-A1D9-EE3A0CDF6982}" />
					<task name="GdiTexture"                              symbol="TASK_GDITEXTURE"                              value="69" eventGUID="{8FDABE35-943F-4190-AE68-2B558F0659FC}" />
					<task name="ArcTextureApple"                         symbol="TASK_ARCTEXTUREAPPLE"                         value="70" eventGUID="{419A2324-DAE8-45ED-A18C-3468165742C2}" />
					<task name="LayerHostWin32"                          symbol="TASK_LAYERHOSTWIN32"                          value="71" eventGUID="{186431D0-BECD-4A66-9F1A-0D22E5A26E4A}" />
					<task name="BitmapTexture"                           symbol="TASK_BITMAPTEXTURE"                           value="72" eventGUID="{CEF22B78-7734-4D6F-A625-19CD2CC13191}" />
				</tasks>
				<opcodes>
					<opcode name="LayerHostEnterLowResourceMode" symbol="OPCODE_LAYERHOST_ENTER_LOWRESOURCEMODE" value="11" />
					<opcode name="LayerHostStartingRecoveryFromLowResourceMode" symbol="OPCODE_LAYERHOST_STARTING_RECOVERY" value="12" />
					<opcode name="LayerHostFinishedRecoveryFromLowResourceMode" symbol="OPCODE_LAYERHOST_FINISHED_RECOVERY" value="13" />
					<opcode name="LayerHostPartiallyRecoveredFromLowResourceMode" symbol="OPCODE_LAYERHOST_PARTIALLY_RECOVERED" value="14" />
					<opcode name="RenderFrame" symbol="OPCODE_RENDERFRAME" value="49" />
					<opcode name="CommandQueued" symbol="OPCODE_COMMAND_QUEUED" value="60" />
					<opcode name="SceneBatch" symbol="OPCODE_BATCH" value="61" />
					<opcode name="UpdateTextures" symbol="OPCODE_UPDATETEXTURES" value="64" />
					<opcode name="BatchPresented" symbol="OPCODE_BATCHPRESENTED" value="65" />
				</opcodes>
				<keywords>
					<keyword name="Memory"              symbol="KEYWORD_AIRSPACE_MEMORY"              mask="0x1"          />
					<keyword name="Timing"              symbol="KEYWORD_AIRSPACE_TIMING"              mask="0x2"          />
					<keyword name="FPS"                 symbol="KEYWORD_AIRSPACE_FPS"                 mask="0x4"          />
					<keyword name="Layer"               symbol="KEYWORD_AIRSPACE_LAYER"               mask="0x8"          />
					<keyword name="Texture"             symbol="KEYWORD_AIRSPACE_TEXTURE"             mask="0x10"         />
					<keyword name="DirectX"             symbol="KEYWORD_AIRSPACE_DIRECTX"             mask="0x20"         />
					<keyword name="CPU"                 symbol="KEYWORD_AIRSPACE_CPU"                 mask="0x40"         />
					<keyword name="GPU"                 symbol="KEYWORD_AIRSPACE_GPU"                 mask="0x80"         />
					<keyword name="Window"              symbol="KEYWORD_AIRSPACE_WINDOW"              mask="0x100"        />
					<keyword name="Initialization"      symbol="KEYWORD_AIRSPACE_INITIALIZATION"      mask="0x200"        />
					<keyword name="Exception"           symbol="KEYWORD_AIRSPACE_EXCEPTION"           mask="0x400"        />
					<keyword name="Animation"           symbol="KEYWORD_AIRSPACE_ANIMATION"           mask="0x800"        />
					<keyword name="Shutdown"            symbol="KEYWORD_AIRSPACE_SHUTDOWN"            mask="0x1000"       />
					<keyword name="AirSpy"              symbol="KEYWORD_AIRSPACE_AIRSPY"              mask="0x2000"       />
					<keyword name="Atlas"               symbol="KEYWORD_AIRSPACE_ATLAS"               mask="0x4000"       />
					<keyword name="LowResourceMode"     symbol="KEYWORD_AIRSPACE_LOW_RESOURCE_MODE"   mask="0x8000"       />
					<keyword name="GDIRendering"        symbol="KEYWORD_AIRSPACE_GDI_RENDERING"       mask="0x10000"      />
					<keyword name="Channel"             symbol="KEYWORD_AIRSPACE_CHANNEL"             mask="0x20000"      />
					<keyword name="Automation"          symbol="KEYWORD_AIRSPACE_AUTOMATION"          mask="0x40000"      />
					<keyword name="DebugLog"            symbol="KEYWORD_AIRSPACE_DEBUG_LOG"           mask="0x80000"      />
					<keyword name="Scrolling"           symbol="KEYWORD_AIRSPACE_SCROLLING"           mask="0x100000"     />
					<keyword name="FrontEnd"            symbol="KEYWORD_AIRSPACE_FRONTEND"            mask="0x200000"     />
					<keyword name="BackEnd"             symbol="KEYWORD_AIRSPACE_BACKEND"             mask="0x400000"     />
					<keyword name="CommandList"         symbol="KEYWORD_AIRSPACE_COMMANDLIST"         mask="0x800000"     />
					<keyword name="Desktop"             symbol="KEYWORD_AIRSPACE_DESKTOP"             mask="0x1000000"    />
					<keyword name="MaxTextureDimension" symbol="KEYWORD_AIRSPACE_MAXTEXTUREDIMENSION" mask="0x2000000"    />
					<keyword name="Immersive"           symbol="KEYWORD_AIRSPACE_IMMERSIVE"           mask="0x4000000"    />
					<keyword name="NullRenderTarget"    symbol="KEYWORD_AIRSPACE_NULLRENDERTARGET"    mask="0x8000000"    />
					<keyword name="WetInk"              symbol="KEYWORD_AIRSPACE_WETINK"              mask="0x10000000"   />
					<keyword name="Scene"               symbol="KEYWORD_AIRSPACE_SCENE"               mask="0x20000000"   />
					<keyword name="Interaction"         symbol="KEYWORD_AIRSPACE_INTERACTION"         mask="0x40000000"   />
					<keyword name="Pointer"             symbol="KEYWORD_AIRSPACE_POINTER"             mask="0x80000000"   />
					<keyword name="LayerTileManager"    symbol="KEYWORD_AIRSPACE_LAYERTILEMANAGER"    mask="0x100000000"  />
					<keyword name="LayerTexture"        symbol="KEYWORD_AIRSPACE_LAYERTEXTURE"        mask="0x200000000"  />
					<keyword name="Tile"                symbol="KEYWORD_AIRSPACE_TILE"                mask="0x400000000"  />
					<keyword name="NullHDC"             symbol="KEYWORD_AIRSPACE_NULLHDC"             mask="0x800000000"  />
					<keyword name="DirectManipulation"  symbol="KEYWORD_AIRSPACE_DIRECTMANIPULATION"  mask="0x1000000000" />
				</keywords>
				<templates>
					<template tid="tidAutomationId">
						<data name="automationId" inType="win:AnsiString" outType="xs:string"/>
						<data name="handle" inType="win:Int32" outType="xs:int"/>
					</template>
					<template tid="tidTextureCreate">
						<data name="width" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="height" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidHresult">
						<data name="hresult" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidDxError">
						<data name="command" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="hresult" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidDeviceCreation">
						<data name="isHardware" inType="win:Boolean" outType="xs:boolean"/>
						<data name="isShared" inType="win:Boolean" outType="xs:boolean"/>
						<data name="featureLevel" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="adapterLuidLowPart" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="adapterLuidHighPart" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidAirSpyMetrics">
						<data name="layerHostCount" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="layerCount" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="textureCount" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidHandle">
						<data name="handle" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidHandleHwnd">
						<data name="handle" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="hwnd" inType="win:Pointer" outType="win:HexInt64"/>
					</template>
					<template tid="tidStoryboard">
						<data name="layerHandle" inType="win:Int32" outType="xs:int"/>
						<data name="animationClass" inType="win:AnsiString" outType="xs:string"/>
						<data name="animation" inType="win:AnsiString" outType="xs:string"/>
						<data name="storyboardHandle" inType="win:Int32" outType="xs:int"/>
						<data name="triggerProperty" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="triggerValue" inType="win:Double" outType="xs:double"/>
						<data name="eventType" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="customEvent" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="looping" inType="win:Boolean" outType="xs:boolean"/>
					</template>
					<template tid="tidKeyframe">
						<data name="storyboardHandle" inType="win:Int32" outType="xs:int"/>
						<data name="layerHandle" inType="win:Int32" outType="xs:int"/>
						<data name="seconds" inType="win:Double" outType="xs:double"/>
						<data name="animationProperty" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="value" inType="win:Double" outType="xs:double"/>
						<data name="instant" inType="win:Boolean" outType="xs:boolean"/>
						<data name="implied" inType="win:Boolean" outType="xs:boolean"/>
						<data name="inherited" inType="win:Boolean" outType="xs:boolean"/>
					</template>
					<template tid="tidSchedulerKeyframe">
						<data name="animationProperty" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="value" inType="win:Double" outType="xs:double"/>
						<data name="hasAnimation" inType="win:Boolean" outType="xs:boolean"/>
						<data name="animating" inType="win:Boolean" outType="xs:boolean"/>
					</template>
					<template tid="tidLayerUpdate">
						<data name="layerHandle" inType="win:Int32" outType="xs:int"/>
						<data name="storyboardHandle" inType="win:Int32" outType="xs:int"/>
						<data name="animationProperty" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="value" inType="win:Double" outType="xs:double"/>
						<data name="animationTick" inType="win:Boolean" outType="xs:boolean"/>
						<data name="animationSeconds" inType="win:Double" outType="xs:double"/>
					</template>
					<template tid="tidStoryboardComplete">
						<data name="storyboardHandle" inType="win:Int32" outType="xs:int"/>
						<data name="started" inType="win:Boolean" outType="xs:boolean"/>
						<data name="finished" inType="win:Boolean" outType="xs:boolean"/>
					</template>
					<template tid="tidAnimationPropertyTarget">
						<data name="layerHandle" inType="win:Int32" outType="xs:int"/>
						<data name="animationProperty" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="finalValue" inType="win:Double" outType="xs:double"/>
						<data name="deleted" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidCompositorFrame">
						<data name="frameId" inType="win:Int32" outType="xs:int"/>
						<data name="frameTimestamp" inType="win:Double" outType="xs:double" />
						<data name="totalTime" inType="win:Double" outType="xs:double" />
						<data name="channelTime" inType="win:Double" outType="xs:double" />
						<data name="animationUpdateTime" inType="win:Double" outType="xs:double" />
						<data name="layoutTime" inType="win:Double" outType="xs:double" />
						<data name="repairDamageTime" inType="win:Double" outType="xs:double" />
						<data name="storyboardsScheduled" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="storyboardScheduleTime" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidRenderFrame">
						<data name="frameId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="frameTimestamp" inType="win:Double" outType="xs:double" />
						<data name="totalTime" inType="win:Double" outType="xs:double" />
						<data name="channelTime" inType="win:Double" outType="xs:double" />
						<data name="updateTime" inType="win:Double" outType="xs:double" />
						<data name="drawingTime" inType="win:Double" outType="xs:double" />
						<data name="compositorBatches" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="canvasesPresented" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="totalCompNodeCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="dirtyCompNodeCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="canvasesPainted" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="pixelsPainted" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="paintTime" inType="win:Double" outType="xs:double" />
						<data name="pixelsPresented" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="pixelsScrolled" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="presentTime" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidCanvasFrame">
						<data name="frameId" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="frameTimestamp" inType="win:Double" outType="xs:double" />
						<data name="handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="totalCompNodeCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="dirtyCompNodeCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="pixelsPainted" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="paintTime" inType="win:Double" outType="xs:double" />
						<data name="pixelsPresented" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="pixelsScrolled" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="presentTime" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidDeviceChange">
						<data name="hardwareMode" inType="win:Boolean" outType="xs:boolean" />
						<data name="sharedDevice" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidAnimationsEnvironmentChange">
						<data name="enabled" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidGdiRenderTargetPresentInfo">
						<data name="pixelsScrolled" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="pixelsPresented" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandQueued">
						<data name="batched" inType="win:Boolean" outType="xs:boolean" />
						<data name="channelCommandId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSceneBatch">
						<data name="start" inType="win:Boolean" outType="xs:boolean" />
						<data name="batchId" inType="win:UInt32"  outType="xs:unsignedInt" />
					</template>
					<template tid="tidRenderFrameStats">
						<data name="frameTimestamp" inType="win:Double" outType="xs:double" />
						<data name="FramesPerSecond" inType="win:Double" outType="xs:double" />
						<data name="PresentsPerSecond" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidUpdateTextures">
						<data name="method" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="numBytesUpdated" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="textureHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="x" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="y" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBatchPresented">
						<data name="batchId" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="frameId" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidBeginDrawReturnedNullRenderTarget">
						<data name="droppedForLowResourceMode" inType="win:Boolean" outType="xs:boolean" />
						<data name="deviceLostNotificationPending" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidHwnd">
						<data name="hwnd" inType="win:Pointer" outType="win:HexInt64"/>
					</template>
					<template tid="tidDevice">
						<data name="isFrontEndDevice" inType="win:Boolean" outType="xs:boolean"/>
					</template>
					<template tid="tidAddDeviceReset">
						<data name="isHardware" inType="win:Boolean" outType="xs:boolean"/>
						<data name="featureLevel" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="adapterLuidLowPart" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="adapterLuidHighPart" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidControlCount">
						<data name="ControlCount" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDebugLog">
						<data name="level" inType="win:Int32" outType="xs:int"/>
						<data name="category" inType="win:Int32" outType="xs:int"/>
						<data name="message" inType="win:UnicodeString" outType="xs:string"/>
					</template>
					<template tid="tidXamlDrawableSurfaceEndDrawStop">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="XamlDrawResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlVirtualSurfaceInvalidateRectInfo">
						<data name="XamlVirtualSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="X" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Y" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsDrawOutstanding" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerSetConfigurationInfo">
						<data name="ObjectHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Mode" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListCompositeSubtractRegionInfo">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualSurfaceUpdateRegionStop">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmBeginDrawDirect2dStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Fidelity" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmEndDrawSurfaceInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmBeginDrawDirect2dStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ID2D1RenderTarget" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmEndDrawCommandListInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListCompositeRequestRectInfo">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OutstandingDraw" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerSetCanvasSizeInfo">
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidXamlVirtualSurfaceUpdateRegionStart">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IVirtualSurfaceImageSourceNative" inType="win:Pointer" outType="win:HexInt64" />
						<data name="NumberOfRects" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListCompositeSubtractInfo">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlDrawableSurfaceBeginDrawDirect2dStop">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ISurfaceImageSourceNativeWithD2D" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ID2D1DeviceContext" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IDXGISurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="OffsetX" inType="win:Int32" outType="xs:int" />
						<data name="OffsetY" inType="win:Int32" outType="xs:int" />
					</template>
					<template tid="tidCommandListCompositeAddStop">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidPrefetchScopeMovedStop">
						<data name="PrefetchScope" inType="win:Pointer" outType="win:HexInt64" />
						<data name="NumberOfRootEvents" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmBeginDrawSurfaceInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ID2D1RenderTarget" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualSurfaceOnUpdatesNeededInfo">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IVirtualSurfaceImageSourceNative" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmEndDrawStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmInvalidateRectInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListCompositeResizeInfo">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
						<data name="OldWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmEndDrawStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlDrawableSurfaceEndDrawStart">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidCommandListCompositeAddStart">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlVirtualSurfaceUpdateRegionRectInfo">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidPrefetchScopeMovedStart">
						<data name="PrefetchScope" inType="win:Pointer" outType="win:HexInt64" />
						<data name="PointX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PointY" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlDrawableSurfaceBeginDrawDirect2dStart">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ISurfaceImageSourceNativeWithD2D" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="DpiX" inType="win:Float" outType="xs:float" />
						<data name="DpiY" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidXamlVirtualSurfaceResizeInfo">
						<data name="XamlVirtualSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="NewWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsDrawOutstanding" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidCommandListDrawInfo">
						<data name="CommandList" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ID2D1DeviceContext" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmBeginDrawCommandListInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ID2D1DeviceContext" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ID2D1CommandList" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidCommandListCompositeTrimInfo">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
						<data name="NumberTrimmed" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerScrollToInfo">
						<data name="CanvasOffsetX" inType="win:Double" outType="xs:double" />
						<data name="CanvasOffsetY" inType="win:Double" outType="xs:double" />
						<data name="AdjustedOffsetX" inType="win:Double" outType="xs:double" />
						<data name="AdjustedOffsetY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidCommandListCompositeDrawStop">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Success" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerZoomToInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Zoom" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidVirtualTextureFrontEndImmResizeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListCompositeDrawStart">
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NumberOfCommandLists" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureFrontEndImmBeginDrawSurfaceInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ISurfaceImageSourceNativeWithD2D" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IDXGISurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="OffsetX" inType="win:Int32" outType="xs:int" />
						<data name="OffsetY" inType="win:Int32" outType="xs:int" />
						<data name="ID2D1DeviceContext" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureFrontEndImmEndDrawStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListVirtualTextureCreateSurfaceInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IVirtualSurfaceImageSource" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureFrontEndImmResizeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListVirtualTextureCreateInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="CommandListRasterizerSource" inType="win:Pointer" outType="win:HexInt64" />
						<data name="CommandListComposite" inType="win:Pointer" outType="win:HexInt64" />
						<data name="VSISTiler" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureCreateSurfaceInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ISurfaceImageSource" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureFrontEndImmBeginDrawDirect2dStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ID2D1RenderTarget" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureFrontEndImmBeginDrawDirect2dStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureConstructInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="XamlMultithreadNativeSurfaceUI" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureFrontEndImmEndDrawStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListVirtualTextureScrollViewerRelationshipInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureScrollViewerRelationshipInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVSISTileConstructInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TextureType" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidVSISTileCreateSurfaceInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IVirtualSurfaceImageSource" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidExceededMaxDimensionInfo">
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="MaxTextureDimension" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidNullRenderTargetInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NullRenderTargetReason" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerOnViewChangingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OffsetX" inType="win:Double" outType="xs:double" />
						<data name="OffsetY" inType="win:Double" outType="xs:double" />
						<data name="VirtualOffsetX" inType="win:Double" outType="xs:double" />
						<data name="VirtualOffsetY" inType="win:Double" outType="xs:double" />
						<data name="ZoomFactor" inType="win:Float" outType="xs:float" />
						<data name="CanvasWidth" inType="win:Double" outType="xs:double" />
						<data name="CanvasHeight" inType="win:Double" outType="xs:double" />
						<data name="VirtualCanvasWidth" inType="win:Double" outType="xs:double" />
						<data name="VirtualCanvasHeight" inType="win:Double" outType="xs:double" />
						<data name="ViewportWidth" inType="win:Double" outType="xs:double" />
						<data name="ViewportHeight" inType="win:Double" outType="xs:double" />
						<data name="IsRTL" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerOnViewChangedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="currentZoom" inType="win:Float" outType="xs:float" />
						<data name="IsIntermediate" inType="win:Boolean" outType="xs:boolean" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidWetInkTextureInkInputModeInfo">
						<data name="InkInputMode" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkTextureCompletedPenStrokeInfo">
						<data name="PenStroke" inType="win:Boolean" outType="xs:boolean" />
						<data name="PresentCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidSetDirectionalityInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Directionality" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkSwapChainPanelDrawInkInfo">
						<data name="Tag1" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="QpcTime" inType="win:UInt64" outType="xs:unsignedLong" />
						<data name="DeltaTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidBasicSwapChainPanelClearStop">
						<data name="HRESULT" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBasicSwapChainPanelClearStart">
						<data name="Bitmap" inType="win:Boolean" outType="xs:boolean" />
						<data name="Thread" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBasicSwapChainPanelCreateDeviceResourcesStart">
						<data name="Resize" inType="win:Boolean" outType="xs:boolean" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Thread" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBasicSwapChainPanelCreateSizeDependentResourcesOnUIThreadStop">
						<data name="Bitmap" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidBasicSwapChainPanelCreateSizeDependentResourcesOnUIThreadStart">
						<data name="Resize" inType="win:Boolean" outType="xs:boolean" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Thread" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBasicSwapChainPanelOnAppSuspendingInfo">
						<data name="Thread" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBasicSwapChainPanelOnAppResumingInfo">
						<data name="TAG" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBasicSwapChainPanelCreateDeviceResourcesStop">
						<data name="Context" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidSetDpiInfo">
						<data name="xDpi" inType="win:Float" outType="xs:float" />
						<data name="yDpi" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidWetInkTextureSetDpiInfo">
						<data name="newDpi" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidHitTestStart">
						<data name="xPoint" inType="win:Int32" outType="xs:int" />
						<data name="yPoint" inType="win:Int32" outType="xs:int" />
					</template>
					<template tid="tidSceneIsLayerHitStop">
						<data name="xPoint" inType="win:Int32" outType="xs:int" />
						<data name="yPoint" inType="win:Int32" outType="xs:int" />
						<data name="Succeeded" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidLayerHitTestStop">
						<data name="xPoint" inType="win:Int32" outType="xs:int" />
						<data name="yPoint" inType="win:Int32" outType="xs:int" />
						<data name="HitLayerHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="xLayer" inType="win:Double" outType="xs:double" />
						<data name="yLayer" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidXamlVirtualSurfaceEndDrawStart">
						<data name="XamlNativeSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidBasicSwapChainPanelIsReadyToPresentInfo">
						<data name="ReadyToPresent" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidWetInkSwapChainPanelEmitPostPresentDataInfo">
						<data name="PointerId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PresentCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidWetInkSwapChainPanelDrawInkErrorInfo">
						<data name="HRESULT" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Tag1" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Tag2" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkSwapChainPanelRefreshInfo">
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidWetInkSwapChainPanelDrawInkStart">
						<data name="StartTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidWetInkSwapChainPanelRenderAndPresentPointsInfo">
						<data name="PointerId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidWetInkSwapChainPanelProcessPresentStatisticsWarningInfo">
						<data name="PresentSyncRefreshCountDelta" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="LastPresentSyncRefreshCountDelta" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkSwapChainPanelOnPointerReleasedInfo">
						<data name="PointerId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidBasicSwapChainPanelAddToEtwLogIfFailedInfo">
						<data name="TAG" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HRESULT" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkSwapChainPanelOnStrokesMoveCompletedInfo">
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
						<data name="PresentCount" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkSwapChainPanelOnInkPointsAvailableInfo">
						<data name="PointerId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewPointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidBasicSwapChainPanelGetFrameStatisticsInfo">
						<data name="PresentCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RefreshCount" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkSwapChainPanelDrawInkStop">
						<data name="StopTime" inType="win:UInt64" outType="xs:unsignedLong" />
						<data name="DeltaTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidWetInkSwapChainPanelOnInkPointsReceivedInfo">
						<data name="PointerId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewPointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidWetInkSwapChainPanelProcessPresentStatisticsErrorInfo">
						<data name="PresentCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PresentRefreshCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncRefreshCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TotalPointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidBasicSwapChainPanelGetLastPresentCountInfo">
						<data name="GetLastPresentCount" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkSwapChainPanelProcessPresentStatisticsInfo">
						<data name="PointerId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TotalPointCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PresentCount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SyncQPCTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidWetInkSwapChainPanelRenderAndPresentPointsStop">
						<data name="Tag" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWetInkSwapChainPanelRenderAndPresentPointsStart">
						<data name="ForceToPresent" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidXamlDrawableSurfaceSuspendDrawStart">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlMultithreadDrawableSurfaceOffThreadConstructInfo">
						<data name="XamlMultithreadDrawableSurfaceOffThread" inType="win:Pointer" outType="win:HexInt64" />
						<data name="XamlMultithreadNativeSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlDrawableSurfaceSetDeviceStart">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="State" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlMultithreadDrawableSurfaceOffThreadEndDrawStop">
						<data name="XamlMultithreadDrawableSurfaceOffThread" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Result" inType="win:Boolean" outType="xs:boolean" />
						<data name="InBatch" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidXamlDrawableSurfaceEndDrawDirect2dStop">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ID2D1DeviceContext" inType="win:Pointer" outType="win:HexInt64" />
						<data name="EndDrawDirect2dResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureXamlMultithreadNativeSurfaceOffThreadInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="XamlMultithreadNativeSurfaceOffThread" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlDrawableSurfaceFlushWorkStop">
						<data name="IDXGIDevice" inType="win:Pointer" outType="win:HexInt64" />
						<data name="HResult" inType="win:Int32" outType="xs:int" />
					</template>
					<template tid="tidXamlMultithreadDrawableSurfaceOffThreadBeginDrawStart">
						<data name="XamlMultithreadNativeSurfaceUI" inType="win:Pointer" outType="win:HexInt64" />
						<data name="X" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Y" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlDrawableSurfaceSuspendDrawStop">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="XamlDrawResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlDrawableSurfaceBeginDrawNativeSurfaceStart">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="State" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlMultithreadDrawableSurfaceConstructInfo">
						<data name="XamlMultithreadDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IXamlMultithreadDrawableSurfaceUser" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlDrawableSurfaceInternalSetDeviceInfo">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IDXGIDevice" inType="win:Pointer" outType="win:HexInt64" />
						<data name="HRESULT" inType="win:UInt32" outType="win:HexInt32" />
					</template>
					<template tid="tidXamlDrawableSurfaceBeginDrawNativeSurfaceStop">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IDXGISurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ID2D1Bitmap1" inType="win:Pointer" outType="win:HexInt64" />
						<data name="offsetX" inType="win:Int32" outType="xs:int" />
						<data name="offsetY" inType="win:Int32" outType="xs:int" />
						<data name="State" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlDrawableSurfaceInitializeSurfaceInfo">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ISurfaceImageSourceNativeWithD2D" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlMultithreadNativeSurfaceOffThreadXamlDrawableSurfaceSetDeviceCommandInfo">
						<data name="XamlMultithreadNativeSurfaceUI" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlDrawableSurfaceEndDrawCommitStop">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="State" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlDrawableSurfaceEndDrawCommitStart">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="State" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlMultithreadDrawableSurfaceOffThreadBeginDrawStop">
						<data name="XamlMultithreadNativeSurfaceUI" inType="win:Pointer" outType="win:HexInt64" />
						<data name="SetDeviceCount" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlDrawableSurfaceBeginDrawStart">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="DpiX" inType="win:Float" outType="xs:float" />
						<data name="DpiY" inType="win:Float" outType="xs:float" />
						<data name="IncludeInverseTransform" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidXamlMultithreadNativeSurfaceUIOnSurfaceContentsLostInfo">
						<data name="XamlMultithreadNativeSurfaceUI" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlDrawableSurfaceEndDrawDirect2dStart">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlDrawableSurfaceSetDeviceStop">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="State" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlMultithreadDrawableSurfaceOffThreadEndDrawStart">
						<data name="XamlMultithreadDrawableSurfaceOffThread" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlDrawableSurfaceBeginDrawStop">
						<data name="XamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Drawable" inType="win:Boolean" outType="xs:boolean" />
						<data name="DeviceMismatch" inType="win:Boolean" outType="xs:boolean" />
						<data name="XamlDrawResult" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ID2D1DeviceContext" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidInteractionInstanceOnUpdateStop">
						<data name="UpdateInstanceStopTime" inType="win:UInt64" outType="xs:unsignedLong" />
						<data name="DeltaTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidInputProcessorOnInteractionStart">
						<data name="X" inType="win:Double" outType="xs:double" />
						<data name="Y" inType="win:Double" outType="xs:double" />
						<data name="pointerId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidInputProcessorOnInteractionStop">
						<data name="X" inType="win:Double" outType="xs:double" />
						<data name="Y" inType="win:Double" outType="xs:double" />
						<data name="pointerId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidInteractionInstanceOnUpdateInfo">
						<data name="UpdateInstanceCalcTime" inType="win:UInt64" outType="xs:unsignedLong" />
						<data name="DeltaTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidScrollingLayerOnDragOverInfo">
						<data name="horizontal" inType="win:Float" outType="xs:float" />
						<data name="vertical" inType="win:Float" outType="xs:float" />
						<data name="left" inType="win:Double" outType="xs:double" />
						<data name="top" inType="win:Double" outType="xs:double" />
						<data name="width" inType="win:Double" outType="xs:double" />
						<data name="height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidInputProcessorHandleLayerInfo">
						<data name="layerCount" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidInteractionInstanceOnUpdateStart">
						<data name="eventType" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="UpdateInstanceStartTime" inType="win:UInt64" outType="xs:unsignedLong" />
					</template>
					<template tid="tidCommandListRasterizeWorkDrawStart">
						<data name="CommandListRasterizeWork" inType="win:Pointer" outType="win:HexInt64" />
						<data name="NumberOfCommandLists" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListRasterizeWorkDrawStop">
						<data name="CommandListRasterizeWork" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidCommandListRasterizeWorkConstructInfo">
						<data name="CommandListRasterizeWork" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidCommandListRasterizerSubmitWorkInfo">
						<data name="CommandListRasterizer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="CommandListRasterizeWork" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidCompositorAreAnimationsDisabledInfo">
						<data name="AreAnimationsDisabled" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidVSISTilerResizeInfo">
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVSISTilerBeginDrawInfo">
						<data name="X" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Y" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVSISTilerInvalidateRectInfo">
						<data name="X" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Y" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListVirtualTextureBeginDrawInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="tileId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RasterizeOnUI" inType="win:Boolean" outType="xs:boolean" />
						<data name="XamlMultithreadVirtualSurfaceUI" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidCommandListVirtualTextureEndDrawInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="tileId" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidVSISTilerInitializeInfo">
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Number" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlMultithreadDrawableSurfaceOffThreadXamlNativeSurfaceSetDeviceCommandInfo">
						<data name="XamlMultithreadNativeSurfaceUI" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceUpdateRegionRectInfo">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceEndDrawStop">
						<data name="XamlNativeSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceUpdateRegionStart">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IVirtualSurfaceImageSourceNative" inType="win:Pointer" outType="win:HexInt64" />
						<data name="NumberOfRects" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceInvalidateRectInfo">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IVirtualSurfaceImageSourceNative" inType="win:Pointer" outType="win:HexInt64" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HRESULT" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceOnUpdatesNeededInfo">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IVirtualSurfaceImageSourceNative" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceResizeInfo">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IVirtualSurfaceImageSourceNative" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HRESULT" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceEndDrawStart">
						<data name="XamlNativeSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceUpdateRegionStop">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualSurfaceConstructInfo">
						<data name="XamlVirtualSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IXamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Opaque" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidXamlMultithreadNativeSurfaceConstructInfo">
						<data name="XamlMultithreadNativeSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IXamlMultithreadDrawableSurfaceUser" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IXamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlSurfaceConstructInfo">
						<data name="XamlSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IXamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Opaque" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidVirtualTextureVirtualTextureStart">
						<data name="VirtualTexture" inType="win:Pointer" outType="win:HexInt64" />
						<data name="VirtualTextureEvents" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Opaque" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidVirtualTextureVirtualTextureStop">
						<data name="VirtualTextureEvents" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlMultithreadVirtualSurfaceConstructInfo">
						<data name="XamlMultithreadNativeSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IXamlMultithreadDrawableSurfaceUser" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IXamlDrawableSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualizedSurfaceConstructInfo">
						<data name="XamlVirtualizedSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidXamlVirtualSurfaceEndDrawInvalidateStart">
						<data name="XamlVirtualSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualSurfaceEndDrawInvalidateStop">
						<data name="XamlVirtualSurface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidXamlVirtualSurfaceEndDrawResizeInfo">
						<data name="XamlVirtualSurface" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidRenderingDeviceLost">
						<data name="OfficeDeviceLost" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidHitTestSlopInfo">
						<data name="InputType" inType="win:Int32" outType="xs:int" />
						<data name="LayerWidth" inType="win:Double" outType="xs:double" />
						<data name="LayerHeight" inType="win:Double" outType="xs:double" />
						<data name="SlopAmount" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SlopUsedX" inType="win:Double" outType="xs:double" />
						<data name="SlopUsedY" inType="win:Double" outType="xs:double" />
						<data name="IsHighDPI" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerBigGridScrollToInfo">
						<data name="CanvasOffsetX" inType="win:Double" outType="xs:double" />
						<data name="CanvasOffsetY" inType="win:Double" outType="xs:double" />
						<data name="AdjustedOffsetX" inType="win:Double" outType="xs:double" />
						<data name="AdjustedOffsetY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerBigGridAdjustViewportPositionInfo">
						<data name="CanvasOffsetX" inType="win:Double" outType="xs:double" />
						<data name="CanvasOffsetY" inType="win:Double" outType="xs:double" />
						<data name="AdjustedOffsetX" inType="win:Double" outType="xs:double" />
						<data name="AdjustedOffsetY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBitmapAllocatorBitmapMemoryExceededMaxLimitInfo">
						<data name="MaxLimit" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidMemoryHelperLowResourceModeStatusChangeInfo">
						<data name="MemoryUsage" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsInLowResourceMode" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidOneUint">
						<data name="value1" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerArrangeOverrideInfo">
						<data name="PendingScrollTo" inType="win:Boolean" outType="xs:boolean" />
						<data name="PendingZoomTo" inType="win:Boolean" outType="xs:boolean" />
						<data name="PendingSetCanvasSize" inType="win:Boolean" outType="xs:boolean" />
						<data name="IsFIrstScroll" inType="win:Boolean" outType="xs:boolean" />
						<data name="OffsetX" inType="win:Double" outType="xs:double" />
						<data name="OffsetY" inType="win:Double" outType="xs:double" />
						<data name="ZoomFactor" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerResetPendingScrollToInfo">
						<data name="ResetPendingScrollTo" inType="win:Boolean" outType="xs:boolean" />
						<data name="PendingScrollTo" inType="win:Boolean" outType="xs:boolean" />
						<data name="OffsetX" inType="win:Double" outType="xs:double" />
						<data name="OffSetY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerResetPendingZoomToInfo">
						<data name="ResetPendingZoomTo" inType="win:Boolean" outType="xs:boolean" />
						<data name="PendingZoomTo" inType="win:Boolean" outType="xs:boolean" />
						<data name="ZoomFactor" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerHandlePropertyChangeInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Property" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Value" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerSetBottomInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Offset" inType="win:Double" outType="xs:double" />
						<data name="ParentAnchor" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidBackEndLayerSetTopInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Offset" inType="win:Double" outType="xs:double" />
						<data name="ParentAnchor" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidScrollingLayerAdjustVirtualizedSpaceInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ViewportOffsetRealX" inType="win:Double" outType="xs:double" />
						<data name="ViewportOffsetRealY" inType="win:Double" outType="xs:double" />
						<data name="OldVirtualOffsetX" inType="win:Double" outType="xs:double" />
						<data name="OldVirtualOffsetY" inType="win:Double" outType="xs:double" />
						<data name="NewVirtualOffsetX" inType="win:Double" outType="xs:double" />
						<data name="NewVirtualOffsetY" inType="win:Double" outType="xs:double" />
						<data name="OldCanvasSizeVirtualX" inType="win:Double" outType="xs:double" />
						<data name="OldCanvasSizeVirtualY" inType="win:Double" outType="xs:double" />
						<data name="NewCanvasSizeVirtualX" inType="win:Double" outType="xs:double" />
						<data name="NewCanvasSizeVirtualY" inType="win:Double" outType="xs:double" />
						<data name="OldPlatformViewportOffsetX" inType="win:Double" outType="xs:double" />
						<data name="OldPlatformViewportOffsetY" inType="win:Double" outType="xs:double" />
						<data name="NewPlatformViewportOffsetX" inType="win:Double" outType="xs:double" />
						<data name="NewPlatformViewportOffsetY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerSetWidthInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="AdjustRightEdge" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidBackEndLayerUpdateHeightPropsInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerSetLeftInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Offset" inType="win:Double" outType="xs:double" />
						<data name="ParentAnchor" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidScrollingLayerApplyScrollInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="finalZoom" inType="win:Float" outType="xs:float" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
						<data name="IsAnimated" inType="win:Boolean" outType="xs:boolean" />
						<data name="VirtualPerimeterChanged" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidBackEndLayerAdjustVisibleTileInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileRectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileRectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileRectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileRectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualOffsetX" inType="win:Double" outType="xs:double" />
						<data name="VirtualOffsetY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerSetHeightInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:Double" outType="xs:double" />
						<data name="AdjustRightEdge" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidBackEndLayerCreateTileInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsRecyclingTile" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerOnViewChangingNextFinalInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualOffsetNextX" inType="win:Double" outType="xs:double" />
						<data name="VirtualOffsetNextY" inType="win:Double" outType="xs:double" />
						<data name="ZoomFactorNext" inType="win:Double" outType="xs:double" />
						<data name="VirtualOffsetFinalX" inType="win:Double" outType="xs:double" />
						<data name="VirtualOffsetFinalY" inType="win:Double" outType="xs:double" />
						<data name="ZoomFactorFinal" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerGetVirtualPerimeterOffsetInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="X" inType="win:Double" outType="xs:double" />
						<data name="Y" inType="win:Double" outType="xs:double" />
						<data name="IsRTL" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidBackEndLayerDeleteTileInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HiddenTileCount" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerFireNotificationsInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ViewportX" inType="win:Double" outType="xs:double" />
						<data name="ViewportY" inType="win:Double" outType="xs:double" />
						<data name="ViewportWidth" inType="win:Double" outType="xs:double" />
						<data name="ViewportHeight" inType="win:Double" outType="xs:double" />
						<data name="Zoom" inType="win:Float" outType="xs:float" />
						<data name="IsMoving" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidBackEndLayerSetRightInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Offset" inType="win:Double" outType="xs:double" />
						<data name="ParentAnchor" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidBackEndLayerEnsureBrushTransformInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldNumberOfVsisTilesX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldNumberOfVsisTilesY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewNumberOfVsisTilesX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewNumberOfVsisTilesY" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBackEndLayerPropogateVirtualizedRectMismatchInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="virtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterHeight" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerPropogateVirtualizationChangedInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="virtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerUpdateWidthPropsInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerClientScrollToInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="finalZoom" inType="win:Float" outType="xs:float" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerHandleVirtualizationChangedInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="virtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterHeight" inType="win:Double" outType="xs:double" />
						<data name="parentVirtualOffsetX" inType="win:Double" outType="xs:double" />
						<data name="parentVirtualOffsetY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerVirtualizeTextureInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualizedRectX" inType="win:Double" outType="xs:double" />
						<data name="VirtualizedRectY" inType="win:Double" outType="xs:double" />
						<data name="VirtualizedRectWidth" inType="win:Double" outType="xs:double" />
						<data name="VirtualizedRectHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerGetVirtualPerimeterInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBackEndLayerLayoutChangedInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBackEndLayerVirtualizationChangedInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBackEndLayerUpdateBorderLayoutInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerHitTestLayerBoundsInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="LayerBoundingBoxX" inType="win:Float" outType="xs:float" />
						<data name="LayerBoundingBoxY" inType="win:Float" outType="xs:float" />
						<data name="LayerBoundingBoxWidth" inType="win:Float" outType="xs:float" />
						<data name="LayerBoundingBoxHeight" inType="win:Float" outType="xs:float" />
						<data name="LayerOffsetFromViewportX" inType="win:Float" outType="xs:float" />
						<data name="LayerOffsetFromViewportY" inType="win:Float" outType="xs:float" />
						<data name="Zoom" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidBackEndLayerHitTestInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PointTestX" inType="win:Float" outType="xs:float" />
						<data name="PointTestY" inType="win:Float" outType="xs:float" />
						<data name="HitTestOptions" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Zoom" inType="win:Float" outType="xs:float" />
						<data name="ViewportOffsetX" inType="win:Float" outType="xs:float" />
						<data name="ViewportOffsetY" inType="win:Float" outType="xs:float" />
						<data name="HeaderType" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ParentScrollingLayer" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SearchForHitTestData" inType="win:Boolean" outType="xs:boolean" />
						<data name="InputSourceType" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBackEndLayerEvaluateLayerProximityInfo">
						<data name="Layer" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PointX" inType="win:Float" outType="xs:float" />
						<data name="PointY" inType="win:Float" outType="xs:float" />
						<data name="PointTestX" inType="win:Float" outType="xs:float" />
						<data name="PointTestY" inType="win:Float" outType="xs:float" />
						<data name="HitTestOptions" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Zoom" inType="win:Float" outType="xs:float" />
						<data name="ViewportOffsetX" inType="win:Float" outType="xs:float" />
						<data name="ViewportOffsetY" inType="win:Float" outType="xs:float" />
						<data name="HeaderType" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ParentScrollingLayer" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SearchForHitTestData" inType="win:Boolean" outType="xs:boolean" />
						<data name="InputSourceType" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerCanvasQueueZoomToInfo">
						<data name="ScrollingLayerCanvas" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ZoomFactor" inType="win:Double" outType="xs:double" />
						<data name="IsAnimated" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerCanvasQueueSetCanvasSizeInfo">
						<data name="ScrollingLayerCanvas" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerCanvasArrangeOverrideInfo">
						<data name="ScrollingLayerCanvas" inType="win:Pointer" outType="win:HexInt64" />
						<data name="PendingScrollTo" inType="win:Boolean" outType="xs:boolean" />
						<data name="PendingZoomTo" inType="win:Boolean" outType="xs:boolean" />
						<data name="PendingSetCanvasSize" inType="win:Boolean" outType="xs:boolean" />
						<data name="IsFirstScroll" inType="win:Boolean" outType="xs:boolean" />
						<data name="ScrollToX" inType="win:Double" outType="xs:double" />
						<data name="ScrollToY" inType="win:Double" outType="xs:double" />
						<data name="ScrollToAnimate" inType="win:Boolean" outType="xs:boolean" />
						<data name="Zoom" inType="win:Double" outType="xs:double" />
						<data name="ZoomAnimate" inType="win:Boolean" outType="xs:boolean" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerCanvasQueueScrollToInfo">
						<data name="ScrollingLayerCanvas" inType="win:Pointer" outType="win:HexInt64" />
						<data name="OffsetX" inType="win:Double" outType="xs:double" />
						<data name="OffsetY" inType="win:Double" outType="xs:double" />
						<data name="IsAnimated" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerCanvasScrollToInfo">
						<data name="ScrollingLayerCanvas" inType="win:Pointer" outType="win:HexInt64" />
						<data name="CanvasOffsetX" inType="win:Double" outType="xs:double" />
						<data name="CanvasOffsetY" inType="win:Double" outType="xs:double" />
						<data name="AdjustedOffsetX" inType="win:Double" outType="xs:double" />
						<data name="AdjustedOffsetY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerCanvasZoomToInfo">
						<data name="ScrollingLayerCanvas" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Zoom" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerCanvasSetCanvasSizeInfo">
						<data name="ScrollingLayerCanvas" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidAirSpaceSetDeviceModeInfo">
						<data name="DeviceMode" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ShareDevice" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidSceneOnDeviceUpdatedInfo">
						<data name="Scene" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidAirSpaceForgetDeviceInfo">
						<data name="ReacquireDevice" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidCompositorSetDeviceModeInfo">
						<data name="DeviceMode" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirectXDeviceResourcesGetDeviceAccessInfo">
						<data name="DirectXDeviceResources" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2dDeviceResourcesGetDeviceAccessInfo">
						<data name="Direct2dDeviceResources" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidSceneIsDeviceLostNotificationPendingInfo">
						<data name="DeviceLossType" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirectXDeviceResourcesDeviceLostInfo">
						<data name="DirectXDeviceResources" inType="win:Pointer" outType="win:HexInt64" />
						<data name="HRESULT" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSceneDiscardAllDeviceResourcesInfo">
						<data name="Scene" inType="win:Pointer" outType="win:HexInt64" />
						<data name="LockDevice" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidDirectXDeviceResourcesHandleDeviceLossInfo">
						<data name="DirectXDeviceResources" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidSceneResetAppDeviceInfo">
						<data name="Scene" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2dDeviceResourcesHandleDeviceLossInfo">
						<data name="Direct2dDeviceResources" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidScrollingLayerCurrentViewportChangedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="currentZoom" inType="win:Float" outType="xs:float" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerSetCanvasSizeStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="CanvasSizeWidth" inType="win:Double" outType="xs:double" />
						<data name="CanvasSizeHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerArrangeStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="finalZoom" inType="win:Float" outType="xs:float" />
						<data name="VirtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerMaxViewportDestinationInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="MaxViewportDestinationX" inType="win:Double" outType="xs:double" />
						<data name="MaxViewportDestinationY" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerOnViewChangingNextInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="nextZoom" inType="win:Float" outType="xs:float" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerSetCanvasSizeStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerFinalViewportChangedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="finalZoom" inType="win:Float" outType="xs:float" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerArrangeAbortInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsIntermediate" inType="win:Boolean" outType="xs:boolean" />
						<data name="LastSteadyZoom" inType="win:Float" outType="xs:float" />
						<data name="Zoom" inType="win:Float" outType="xs:float" />
						<data name="IntermediateCount" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerArrangeStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="currentZoom" inType="win:Float" outType="xs:float" />
						<data name="VirtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerCanvasChangeViewInfo">
						<data name="ScrollingLayerCanvas" inType="win:Pointer" outType="win:HexInt64" />
						<data name="IsScroll" inType="win:Boolean" outType="xs:boolean" />
						<data name="IsZoom" inType="win:Boolean" outType="xs:boolean" />
						<data name="X" inType="win:Double" outType="xs:double" />
						<data name="Y" inType="win:Double" outType="xs:double" />
						<data name="Zoom" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidScrollingLayerUpdateScrollViewportCommandImmInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ViewportX" inType="win:Double" outType="xs:double" />
						<data name="ViewportY" inType="win:Double" outType="xs:double" />
						<data name="ViewportWidth" inType="win:Double" outType="xs:double" />
						<data name="ViewportHeight" inType="win:Double" outType="xs:double" />
						<data name="Zoom" inType="win:Double" outType="xs:double" />
						<data name="IsMoving" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidLocalBlocklistInfo">
						<data name="AllAppsBlocked" inType="win:Boolean" outType="xs:boolean" />
						<data name="BlockedDeviceId" inType="win:UnicodeString" outType="xs:string"/>
						<data name="BlockedDriverVersion" inType="win:UnicodeString" outType="xs:string"/>
						<data name="CrashHistory" inType="win:UnicodeString" outType="xs:string"/>
						<data name="SecsBetweenCrashes" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidLocalBlocklistDriverUpdated">
						<data name="DeviceId" inType="win:UnicodeString" outType="xs:string"/>
						<data name="BlockedDriverVersion" inType="win:UnicodeString" outType="xs:string"/>
						<data name="UpdatedDriverVersion" inType="win:UnicodeString" outType="xs:string"/>
					</template>
					<template tid="tidAnimationPropertyChange">
						<data name="eventType" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="animationProperty" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="newValue" inType="win:Double" outType="xs:double"/>
					</template>
					<template tid="tidAnimationInstanceCreation">
						<data name="animationClass" inType="win:AnsiString" outType="xs:string"/>
						<data name="animation" inType="win:AnsiString" outType="xs:string"/>
						<data name="animationInstanceId" inType="win:Int32" outType="xs:int"/>
						<data name="animationEvent" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="customEvent" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="looping" inType="win:Boolean" outType="xs:boolean"/>
					</template>
					<template tid="tidAnimationInstanceCancellation">
						<data name="animationInstanceId" inType="win:Int32" outType="xs:int"/>
						<data name="animationClass" inType="win:AnsiString" outType="xs:string"/>
						<data name="animation" inType="win:AnsiString" outType="xs:string"/>
					</template>
					<template tid="tidAnimationInstanceCompletion">
						<data name="animationInstanceId" inType="win:Int32" outType="xs:int"/>
						<data name="animationClass" inType="win:AnsiString" outType="xs:string"/>
						<data name="animation" inType="win:AnsiString" outType="xs:string"/>
					</template>
					<template tid="tidKeyframeAddition">
						<data name="animationInstanceHandle" inType="win:Int32" outType="xs:int"/>
						<data name="animationClass" inType="win:AnsiString" outType="xs:string"/>
						<data name="animation" inType="win:AnsiString" outType="xs:string"/>
						<data name="seconds" inType="win:Double" outType="xs:double"/>
						<data name="animationProperty" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="value" inType="win:Double" outType="xs:double"/>
					</template>
					<template tid="tidAnimationClassChange">
						<data name="airSpaceLayerHandle" inType="win:Int32" outType="xs:int"/>
						<data name="classCookie" inType="win:Int32" outType="xs:int"/>
						<data name="animationClassId" inType="win:Int32" outType="xs:int"/>
					</template>
					<template tid="tidAnimationClassChangeAll">
						<data name="airSpaceLayerHandle" inType="win:Int32" outType="xs:int"/>
					</template>
					<template tid="tidContextVariableProcessed">
						<data name="animationInstanceHandle" inType="win:Int32" outType="xs:int"/>
						<data name="contextVariableId" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="contextableValue" inType="win:Double" outType="xs:double"/>
					</template>
					<template tid="tidGraphicsHwCrashUsingSw">
						<data name="AppCrashingInHw" inType="win:UnicodeString" outType="xs:string"/>
					</template>
					<template tid="tidAnimationDisabledReason">
						<data name="SafeMode" inType="win:Boolean" outType="xs:boolean"/>
						<data name="TerminalServer" inType="win:Boolean" outType="xs:boolean"/>
						<data name="Registry" inType="win:Boolean" outType="xs:boolean"/>
						<data name="AdminPolicy" inType="win:Boolean" outType="xs:boolean"/>
						<data name="AnimationDisabled" inType="win:Boolean" outType="xs:boolean"/>
						<data name="EaseOfAccess" inType="win:Boolean" outType="xs:boolean"/>
						<data name="WARP" inType="win:Boolean" outType="xs:boolean"/>
					</template>
					<template tid="tidScrollingLayerZoomChangedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldZoomFactor" inType="win:Float" outType="xs:float" />
						<data name="NewZoomFactor" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidScrollingLayerViewportPositionChangingFinalInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="finalZoom" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidScrollingLayerViewportPositionChangingCurrentInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="currentZoom" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidScrollingLayerSetVirtualPerimeterInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="oldVirtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="oldVirtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="oldVirtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="oldVirtualPerimeterHeight" inType="win:Double" outType="xs:double" />
						<data name="newVirtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="newVirtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="newVirtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="newVirtualPerimeterHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerArrangePendingScrollInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="finalZoom" inType="win:Float" outType="xs:float" />
						<data name="IsPendingScroll" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerFinalPlatformViewportOffsetChangedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListVirtualTextureWinCompOnAppResumingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerTileManagerResetPrefetchScopeInfo">
						<data name="LayerTileManager" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidScrollingLayerWinCompSetupScrollBarsInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerCommandListVirtualTextureWinCompDestroyInfo">
						<data name="LCLVT" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidSurfaceLayerBitmapTextureWinCompSetTileInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidLayerCommandListVirtualTextureWinCompCreateInfo">
						<data name="LCLVT" inType="win:Pointer" outType="win:HexInt64" />
						<data name="LTM" inType="win:Pointer" outType="win:HexInt64" />
						<data name="LayerHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TextureHandle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerCommandListVirtualTextureWinCompLayoutChangedInternalInfo">
						<data name="LCLVT" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ContentZoom" inType="win:Float" outType="xs:float" />
						<data name="HighDpiScaleFactor" inType="win:Float" outType="xs:float" />
						<data name="BoundsLeft" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsTop" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PrefetchDistanceX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PrefetchDistanceY" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListVirtualTextureWinCompDestroyInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerCommandListVirtualTextureWinCompResetScrollingLayerParentInternalInfo">
						<data name="LCLVT" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidSurfaceLayerBitmapTextureWinCompCompositionSurfaceChangedInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Surface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidCommandListVirtualTextureWinCompCreateInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Playback" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidBitmapTextureWinCompSetStretchModeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldStretchMode" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewStretchMode" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompCreateInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompResizeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBitmapTextureWinCompCreateInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsArc" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidVirtualTextureWinCompDestroyInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompScrollBarIndicatorModeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ScrollingIndicatorMode" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompSetPrefetchSizeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="X" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Y" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBitmapTextureWinCompDestroyInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerVirtualTextureWinCompCreateInfo">
						<data name="LayerVirtualTexture" inType="win:Pointer" outType="win:HexInt64" />
						<data name="LTM" inType="win:Pointer" outType="win:HexInt64" />
						<data name="LayerHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TextureHandle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSurfaceLayerBitmapTextureWinCompOnLayerSizeChangedInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidSurfaceLayerBitmapTextureWinCompApplyStretchModeInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
						<data name="StretchMode" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBitmapTextureWinCompCreateTileInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerVirtualTextureWinCompDestroyInfo">
						<data name="LayerVirtualTexture" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidLayerCommandListVirtualTextureWinCompSetScrollingLayerParentInternalInfo">
						<data name="LCLVT" inType="win:Pointer" outType="win:HexInt64" />
						<data name="ContentZoom" inType="win:Float" outType="xs:float" />
						<data name="HighDpiScaleFactor" inType="win:Float" outType="xs:float" />
						<data name="BoundsLeft" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsTop" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PrefetchDistanceX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PrefetchDistanceY" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompOnAppSuspendingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBitmapTextureWinCompOnAppResumingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompOnAppResumingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBitmapTextureWinCompOnAppSuspendingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSurfaceLayerBitmapTextureWinCompDrawForTilingInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSurfaceLayerBitmapTextureWinCompDestroyInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidSurfaceLayerBitmapTextureWinCompCreateInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
						<data name="LayerHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TextureHandle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCommandListVirtualTextureWinCompOnAppSuspendingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerTileManagerSetPrefetchScopeInfo">
						<data name="LayerTileManager" inType="win:Pointer" outType="win:HexInt64" />
						<data name="BoundsLeft" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsTop" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BoundsHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PrefetchDistanceX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="PrefetchDistanceY" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompInvalidateRectInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="X" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Y" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureWinCompBeginDrawStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSurfaceLayerSwapChainTextureWinCompCreateInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
						<data name="LayerHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TextureHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Surface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidSwapChainTextureWinCompDeviceLossInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWindowCompositorSetRenderingDeviceFailureInfo">
						<data name="WindowCompositor" inType="win:Pointer" outType="win:HexInt64" />
						<data name="WindowCompositionGraphicsDevice" inType="win:Pointer" outType="win:HexInt64" />
						<data name="DxgiDevice" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureWinCompHandleDrawHrInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWindowCompositorCreateInfo">
						<data name="WindowCompositor" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Compositor" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureWinCompOnSuspendInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureWinCompEndDrawStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWindowCompositorDestroyInfo">
						<data name="WindowCompositor" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidVirtualTextureWinCompHandleDrawHrInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureWinCompSetStretchModeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="StretchMode" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureWinCompEnsureTileInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompOnResumeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompOnResumeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSurfaceLayerSwapChainTextureWinCompDestroyInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureWinCompDeviceLossInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompCreateFrontEndInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IgnoreAlpha" inType="win:Boolean" outType="xs:boolean" />
						<data name="IsCommandListBacked" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidSwapChainTextureWinCompCreateInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Opaque" inType="win:Boolean" outType="xs:boolean" />
						<data name="Depth" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWindowCompositorEnsureWindowCompositionGraphicsDeviceInfo">
						<data name="WindowCompositor" inType="win:Pointer" outType="win:HexInt64" />
						<data name="DxgiDevice" inType="win:Pointer" outType="win:HexInt64" />
						<data name="WindowCompositionGraphicsDevice" inType="win:Pointer" outType="win:HexInt64" />
						<data name="GraphicsDevice" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidVirtualTextureWinCompDestroyFrontEndInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWindowCompositionGraphicsDeviceSetRenderingDeviceInfo">
						<data name="WindowCompositionGraphicsDevice" inType="win:Pointer" outType="win:HexInt64" />
						<data name="GraphicsDevice" inType="win:Pointer" outType="win:HexInt64" />
						<data name="DxgiDevice" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureWinCompEndDrawStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompDestroyInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureWinCompBeginDrawStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSurfaceLayerSwapChainTextureWinCompCompositionSurfaceChangedInfo">
						<data name="LayerTexture" inType="win:Pointer" outType="win:HexInt64" />
						<data name="Surface" inType="win:Pointer" outType="win:HexInt64" />
					</template>
					<template tid="tidDirect2DTextureWinCompResizeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompDeviceLossInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompOnAppSuspendingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureWinCompOnSuspendInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompHandleDeviceHrInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureWinCompOnResumeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompDestroyFrontEndInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompOnSuspendInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidDirect2DTextureWinCompBeginDrawNullRenderTargetInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NullRenderTargetReason" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompCreateFrontEndInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Depth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Opaque" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerWinCompOnPointerWheelChangedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="isMouseWheelSupportEnabled" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerWinCompTryRedirectForManipulationInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerWinCompUpdateBorderLayoutInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BorderPosition" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompSetupInteractionTrackerInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerClearZoomSnapPointsInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerSetRegularSnapPointsInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Type" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="isHorizontal" inType="win:Boolean" outType="xs:boolean" />
						<data name="Distance" inType="win:Float" outType="xs:float" />
						<data name="Offset" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidScrollingLayerSetSnapPointsTypeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Type" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="isHorizontal" inType="win:Boolean" outType="xs:boolean" />
						<data name="isZoom" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerSetIrregularSnapPointsInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Type" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="isHorizontal" inType="win:Boolean" outType="xs:boolean" />
						<data name="Size" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerAddZoomSnapPointInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="zoomFactor" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidTileWinCompCreateSurfaceFailureInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidTileWinCompEndDrawFailureInfo">
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCompositorWinCompIsEnabledInfo">
						<data name="WinCompEnabled" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidSwapChainTextureWinCompBeginDrawAppSuspendedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Type" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompBeginDrawEnsureResourcesInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Type" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompBeginDrawWrongThreadInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Type" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompBeginDrawNonRenderTextureInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Type" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidSwapChainTextureWinCompBeginDrawNestedDrawInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Type" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureBaseWinCompOnAppResumingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureBaseWinCompOnAppSuspendingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureBaseWinCompInvalidateRectInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="X" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Y" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureBaseWinCompResizeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="OldHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NewHeight" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureBaseWinCompSetPrefetchSizeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="X" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Y" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompChainingSupportChangedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="isXChainingSupportEnabled" inType="win:Boolean" outType="xs:boolean" />
						<data name="isYChainingSupportEnabled" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerWinCompValuesChangedStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompRequestIgnoredInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompInertiaStateEnteredInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsViewportMoving" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerWinCompApplyScrollInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="finalZoom" inType="win:Float" outType="xs:float" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
						<data name="IsViewportMoving" inType="win:Boolean" outType="xs:boolean" />
						<data name="IsClientScroll" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerWinCompValuesChangedWorkaroundInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompValuesChangedStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompRejiggerStop">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="zoom" inType="win:Float" outType="xs:float" />
						<data name="VirtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="VirtualPerimeterHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerWinCompInteractingStateEnteredInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompRejiggerStart">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompUpdateViewportPositionInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedX_Rtl" inType="win:Double" outType="xs:double" />
						<data name="RealUnzoomedY_Rtl" inType="win:Double" outType="xs:double" />
						<data name="currentZoom" inType="win:Float" outType="xs:float" />
						<data name="Width" inType="win:Double" outType="xs:double" />
						<data name="Height" inType="win:Double" outType="xs:double" />
						<data name="IsViewportMoving" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerWinCompIdleStateEnteredInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompCustomAnimationStateEnteredInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsViewportMoving" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerUpdateMinMaxPositionInfo">
						<data name="ObjectHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="MinPositionX" inType="win:Double" outType="xs:double" />
						<data name="MinPositionY" inType="win:Double" outType="xs:double" />
						<data name="MaxPositionX" inType="win:Double" outType="xs:double" />
						<data name="MaxPositionY" inType="win:Double" outType="xs:double" />
						<data name="MinMaxOrder" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidVirtualTextureFrontEndWin32BeginDrawGdiInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectX" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectY" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RectHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidAnimationTracker">
						<data name="animationTracker" inType="win:UInt64" outType="xs:unsignedLong"/>
					</template>
					<template tid="tidAnimationTrackerTracking">
						<data name="animationTracker" inType="win:UInt64" outType="xs:unsignedLong"/>
						<data name="handle" inType="win:UInt32" outType="xs:unsignedInt"/>
						<data name="duration" inType="win:UInt32" outType="xs:unsignedInt"/>
					</template>
					<template tid="tidTileWinCompCreateCompositionSurfaceInfo">
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidLayerHostWin32SetDirectManipulationActiveInfo">
						<data name="HResult" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IsActivating" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidScrollingLayerWinCompValuesChangedRequestIdInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RequestId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidBackEndLayerPropogatevirtualPerimeterMismatchInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="virtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterHeight" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidBackEndLayerPropogateVirtualizedRectMismatchInfoInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="virtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="virtualPerimeterHeight" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterX" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterY" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterWidth" inType="win:Double" outType="xs:double" />
						<data name="CalculatedvirtualPerimeterHeight" inType="win:Double" outType="xs:double" />
					</template>
					<template tid="tidScrollingLayerWinCompTryUpdatePositionWithAnimationInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RequestId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompTryUpdateScaleWithAnimationInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ZoomCenterPointX" inType="win:Float" outType="xs:float" />
						<data name="ZoomCenterPointY" inType="win:Float" outType="xs:float" />
						<data name="RequestId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompTryUpdatePositionWithoutClampingInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="RequestId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompTryUpdateScaleInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="ZoomCenterPointX" inType="win:Float" outType="xs:float" />
						<data name="ZoomCenterPointY" inType="win:Float" outType="xs:float" />
						<data name="RequestId" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompUpdatePlatformCanvasSizeInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="canvasSizeX" inType="win:Float" outType="xs:float" />
						<data name="canvasSizeY" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidResizeExceededMaxDimensionInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Width" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="Height" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="MaxTextureDimension" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidScrollingLayerWinCompApplyScrollOffsetsAdjustedInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VirtualZoomedX" inType="win:Double" outType="xs:double" />
						<data name="VirtualZoomedY" inType="win:Double" outType="xs:double" />
						<data name="finalZoom" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidTileWinCompSurfaceNotCoveredByInitialDrawInfo">
						<data name="SurfaceWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="SurfaceHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="UpdateWidth" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="UpdateHeight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TextureHandle" inType="win:Int64" outType="xs:long" />
					</template>
					<template tid="tidBitmapTextureInvalidSetStretchModeUsage">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="StretchMode" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidCopyBitmapTextureInvalidUsage">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="hasCalledBeginDraw" inType="win:Boolean" outType="xs:boolean" />
						<data name="IsDrawing" inType="win:Boolean" outType="xs:boolean" />
					</template>
					<template tid="tidChannelActivityInfo">
						<data name="Command" inType="win:UnicodeString" outType="xs:string"/>
						<data name="BatchDesc" inType="win:UnicodeString" outType="xs:string" />
						<data name="V1Name" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V1Val" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V2Name" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V2Val" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V3Name" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V3Val" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V4Name" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V4Val" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V5Name" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V5Val" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V6Name" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V6Val" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V7Name" inType="win:UnicodeString" outType="xs:string"/>
						<data name="V7Val" inType="win:UnicodeString" outType="xs:string"/>
					</template>
					<template tid="tidLayerApplyIntermediateVirtualTextureUntilContentReady">
						<data name="LayerHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TextureHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="IncomingVirtualTextureAction" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWinCompAnimationSchedulerScrollAnimationInfo">
						<data name="Handle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="x" inType="win:Float" outType="xs:float" />
						<data name="y" inType="win:Float" outType="xs:float" />
					</template>
					<template tid="tidExceptionAbnormalStateEnteredInfo">
						<data name="AbnormalState" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidInputProcessingPointerInfo">
						<data name="PointerID" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidVirtualTextureOptimizerTileLog">
						<data name="VirtualTextureHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="VTOActionEnum" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileTop" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileLeft" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileBottom" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="TileRight" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="StandbyTileBucket" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWinCompVisualCaptureWait">
						<data name="VisualCaptureWaitTimeMS" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidWinCompBlockingCommandWait">
						<data name="CommandId" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BlockingCommandExecutionTimeMS" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="NumVisualCapturesExecuted" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="LastVisualCaptureWaitTimeMS" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="CumulativeVisualCapturesWaitMS" inType="win:UInt32" outType="xs:unsignedInt" />
					</template>
					<template tid="tidInitialSceneBatch">
						<data name="SceneHandle" inType="win:UInt32" outType="xs:unsignedInt" />
						<data name="BatchId" inType="win:UInt32"  outType="xs:unsignedInt" />
					</template>
				</templates>
				
			</provider>
		</events>
		<counters xmlns:auto-ns1="http://schemas.microsoft.com/win/2004/08/events" xmlns="http://schemas.microsoft.com/win/2005/12/counters">
		</counters>
	</instrumentation>
	<localization>
		<resources culture="en-us">
			<stringTable>
				<string id="OfficeAirSpaceProviderName" value="Microsoft-Office-AirSpace" />
				<string id="XamlDrawableSurface.EndDraw.Stop" value="EndDraw" />
				<string id="XamlVirtualizedSurface.InvalidateRect.Info" value="InvalidateRect" />
				<string id="ScrollingLayer.SetConfiguration.Info" value="SetConfiguration" />
				<string id="CommandListComposite.SubtractRegion.Info" value="SubtractRegion" />
				<string id="XamlVirtualizedSurface.UpdateRegion.Stop" value="UpdateRegion" />
				<string id="VirtualTexture.FrontEndImmBeginDrawDirect2d.Start" value="FrontEndImmBeginDrawDirect2d" />
				<string id="VirtualTexture.FrontEndImmEndDrawSurface.Info" value="FrontEndImmEndDrawSurface" />
				<string id="VirtualTexture.FrontEndImmBeginDrawDirect2d.Stop" value="FrontEndImmBeginDrawDirect2d" />
				<string id="VirtualTexture.FrontEndImmEndDrawCommandList.Info" value="FrontEndImmEndDrawCommandList" />
				<string id="CommandListComposite.RequestRect.Info" value="RequestRect" />
				<string id="ScrollingLayer.SetCanvasSize.Info" value="SetCanvasSize" />
				<string id="XamlVirtualizedSurface.UpdateRegion.Start" value="UpdateRegion" />
				<string id="CommandListComposite.Subtract.Info" value="Subtract" />
				<string id="XamlDrawableSurface.BeginDrawDirect2d.Stop" value="BeginDrawDirect2d" />
				<string id="CommandListComposite.Add.Stop" value="Add" />
				<string id="PrefetchScope.Moved.Stop" value="Moved" />
				<string id="VirtualTexture.FrontEndImmBeginDrawSurface.Info" value="FrontEndImmBeginDrawSurface" />
				<string id="XamlVirtualizedSurface.OnUpdatesNeeded.Info" value="OnUpdatesNeeded" />
				<string id="VirtualTexture.FrontEndImmEndDraw.Stop" value="FrontEndImmEndDraw" />
				<string id="VirtualTexture.FrontEndImmInvalidateRect.Info" value="FrontEndImmInvalidateRect" />
				<string id="CommandListComposite.Resize.Info" value="Resize" />
				<string id="VirtualTexture.FrontEndImmEndDraw.Start" value="FrontEndImmEndDraw" />
				<string id="XamlDrawableSurface.EndDraw.Start" value="EndDraw" />
				<string id="CommandListComposite.Add.Start" value="Add" />
				<string id="XamlVirtualizedSurface.UpdateRegionRect.Info" value="UpdateRegionRect" />
				<string id="PrefetchScope.Moved.Start" value="Moved" />
				<string id="XamlDrawableSurface.BeginDrawDirect2d.Start" value="BeginDrawDirect2d" />
				<string id="XamlVirtualizedSurface.Resize.Info" value="Resize" />
				<string id="CommandList.Draw.Info" value="Draw" />
				<string id="VirtualTexture.FrontEndImmBeginDrawCommandList.Info" value="FrontEndImmBeginDrawCommandList" />
				<string id="CommandListComposite.Trim.Info" value="Trim" />
				<string id="ScrollingLayer.ScrollTo.Info" value="ScrollTo" />
				<string id="CommandListComposite.Draw.Stop" value="Draw" />
				<string id="ScrollingLayer.ZoomTo.Info" value="ZoomTo" />
				<string id="VirtualTexture.FrontEndImmResize.Info" value="FrontEndImmResize" />
				<string id="CommandListComposite.Draw.Start" value="Draw" />
				<string id="Direct2DTexture.FrontEndImmBeginDrawSurface.Info" value="FrontEndImmBeginDrawSurface" />
				<string id="Direct2DTexture.FrontEndImmEndDraw.Start" value="FrontEndImmEndDraw" />
				<string id="CommandListVirtualTexture.CreateSurface.Info" value="CreateSurface" />
				<string id="Direct2DTexture.FrontEndImmResize.Info" value="FrontEndImmResize" />
				<string id="CommandListVirtualTexture.Create.Info" value="Create" />
				<string id="Direct2DTexture.CreateSurface.Info" value="CreateSurface" />
				<string id="VirtualTexture.CreateSurface.Info" value="CreateSurface" />
				<string id="Direct2DTexture.FrontEndImmBeginDrawDirect2d.Stop" value="FrontEndImmBeginDrawDirect2d" />
				<string id="Direct2DTexture.FrontEndImmBeginDrawDirect2d.Start" value="FrontEndImmBeginDrawDirect2d" />
				<string id="Direct2DTexture.Construct.Info" value="Construct" />
				<string id="Direct2DTexture.FrontEndImmEndDraw.Stop" value="FrontEndImmEndDraw" />
				<string id="VirtualTexture.Construct.Info" value="Construct" />
				<string id="CommandListVirtualTexture.ScrollViewerRelationship.Info" value="ScrollViewerRelationship" />
				<string id="VirtualTexture.ScrollViewerRelationship.Info" value="ScrollViewerRelationship" />
				<string id="VSISTile.Construct.Info" value="Construct" />
				<string id="VSISTile.CreateSurface.Info" value="CreateSurface" />
				<string id="SceneD.CreateTextureFromWicBitmapExceededMaxDimension.Info" value="CreateTextureFromWicBitmapExceededMaxDimension" />
				<string id="LayerHostD.InternalOnSizeExceededMaxDimension.Info" value="InternalOnSizeExceededMaxDimension" />
				<string id="SurfaceManager.RequestSurfaceExceededMaxDimension.Info" value="RequestSurfaceExceededMaxDimension" />
				<string id="WetInkTexture.ResizeExceededMaxDimension.Info" value="ResizeExceededMaxDimension" />
				<string id="Scene.CreateSwapChainTextureExceededMaxDimension.Info" value="CreateSwapChainTextureExceededMaxDimension" />
				<string id="LayerHostI.InternalOnSizeExceededMaxDimension.Info" value="InternalOnSizeExceededMaxDimension" />
				<string id="SceneI.CreateTextureFromWicBitmapExceededMaxDimension.Info" value="CreateTextureFromWicBitmapExceededMaxDimension" />
				<string id="SceneD.CreateGdiTextureExceededMaxDimension.Info" value="CreateGdiTextureExceededMaxDimension" />
				<string id="Direct2DTexture.BeginDrawNullRenderTarget.Info" value="BeginDrawNullRenderTarget" />
				<string id="VirtualTexture.BeginDrawDirect2dNullRenderTarget.Info" value="BeginDrawDirect2dNullRenderTarget" />
				<string id="ScrollingLayer.OnViewChanging.Info" value="OnViewChanging" />
				<string id="ScrollingLayer.OnViewChanged.Info" value="OnViewChanged" />
				<string id="WetInkTexture.InkInputMode.Info" value="InkInputMode" />
				<string id="WetInkTexture.CompletedPenStroke.Info" value="CompletedPenStroke" />
				<string id="XamlHostingLayer.SetDirectionality.Info" value="SetDirectionality" />
				<string id="ScrollingLayer.SetDirectionality.Info" value="SetDirectionality" />
				<string id="WetInkSwapChainPanel.DrawInk.Info" value="DrawInk" />
				<string id="BasicSwapChainPanel.Clear.Stop" value="Clear" />
				<string id="BasicSwapChainPanel.Clear.Start" value="Clear" />
				<string id="BasicSwapChainPanel.CreateDeviceResources.Start" value="CreateDeviceResources" />
				<string id="BasicSwapChainPanel.CreateSizeDependentResourcesOnUIThread.Stop" value="CreateSizeDependentResourcesOnUIThread" />
				<string id="BasicSwapChainPanel.CreateSizeDependentResourcesOnUIThread.Start" value="CreateSizeDependentResourcesOnUIThread" />
				<string id="BasicSwapChainPanel.OnAppSuspending.Info" value="OnAppSuspending" />
				<string id="BasicSwapChainPanel.OnAppResuming.Info" value="OnAppResuming" />
				<string id="BasicSwapChainPanel.CreateDeviceResources.Stop" value="CreateDeviceResources" />
				<string id="Direct2DTexture.SetDpi.Info" value="SetDpi" />
				<string id="VirtualTexture.SetDpi.Info" value="SetDpi" />
				<string id="WetInkTexture.SetDpi.Info" value="SetDpi" />
				<string id="Layer.HitTest.Start" value="HitTest" />
				<string id="Scene.IsLayerHit.Stop" value="IsLayerHit" />
				<string id="Scene.IsLayerHit.Start" value="IsLayerHit" />
				<string id="Layer.HitTest.Stop" value="HitTest" />
				<string id="XamlVirtualizedSurface.EndDraw.Start" value="EndDraw" />
				<string id="XamlVirtualizedSurface.EndDraw.Stop" value="EndDraw" />
				<string id="BasicSwapChainPanel.IsReadyToPresent.Info" value="IsReadyToPresent" />
				<string id="WetInkSwapChainPanel.EmitPostPresentData.Info" value="EmitPostPresentData" />
				<string id="WetInkSwapChainPanel.DrawInkError.Info" value="DrawInkError" />
				<string id="WetInkSwapChainPanel.Refresh.Info" value="Refresh" />
				<string id="WetInkSwapChainPanel.DrawInk.Start" value="DrawInk" />
				<string id="WetInkSwapChainPanel.RenderAndPresentPoints.Info" value="RenderAndPresentPoints" />
				<string id="WetInkSwapChainPanel.ProcessPresentStatisticsWarning.Info" value="ProcessPresentStatisticsWarning" />
				<string id="WetInkSwapChainPanel.OnPointerReleased.Info" value="OnPointerReleased" />
				<string id="BasicSwapChainPanel.AddToEtwLogIfFailed.Info" value="AddToEtwLogIfFailed" />
				<string id="WetInkSwapChainPanel.OnStrokesMoveCompleted.Info" value="OnStrokesMoveCompleted" />
				<string id="WetInkSwapChainPanel.OnInkPointsAvailable.Info" value="OnInkPointsAvailable" />
				<string id="BasicSwapChainPanel.GetFrameStatistics.Info" value="GetFrameStatistics" />
				<string id="WetInkSwapChainPanel.DrawInk.Stop" value="DrawInk" />
				<string id="WetInkSwapChainPanel.OnInkPointsReceived.Info" value="OnInkPointsReceived" />
				<string id="WetInkSwapChainPanel.ProcessPresentStatisticsError.Info" value="ProcessPresentStatisticsError" />
				<string id="BasicSwapChainPanel.GetLastPresentCount.Info" value="GetLastPresentCount" />
				<string id="WetInkSwapChainPanel.ProcessPresentStatistics.Info" value="ProcessPresentStatistics" />
				<string id="WetInkSwapChainPanel.RenderAndPresentPoints.Stop" value="RenderAndPresentPoints" />
				<string id="WetInkSwapChainPanel.RenderAndPresentPoints.Start" value="RenderAndPresentPoints" />
				<string id="XamlDrawableSurface.SuspendDraw.Start" value="SuspendDraw" />
				<string id="XamlMultithreadDrawableSurfaceOffThread.Construct.Info" value="Construct" />
				<string id="XamlDrawableSurface.SetDevice.Start" value="SetDevice" />
				<string id="XamlMultithreadDrawableSurfaceOffThread.EndDraw.Stop" value="EndDraw" />
				<string id="XamlDrawableSurface.EndDrawDirect2d.Stop" value="EndDrawDirect2d" />
				<string id="Direct2DTexture.XamlMultithreadDrawableSurfaceOffThread.Info" value="XamlMultithreadDrawableSurfaceOffThread" />
				<string id="XamlDrawableSurface.FlushWork.Stop" value="FlushWork" />
				<string id="XamlMultithreadDrawableSurfaceOffThread.BeginDraw.Start" value="BeginDraw" />
				<string id="XamlDrawableSurface.SuspendDraw.Stop" value="SuspendDraw" />
				<string id="XamlDrawableSurface.BeginDrawNativeSurface.Start" value="BeginDrawNativeSurface" />
				<string id="XamlMultithreadNativeSurface.Construct.Info" value="Construct" />
				<string id="XamlDrawableSurface.InternalSetDevice.Info" value="InternalSetDevice" />
				<string id="XamlDrawableSurface.BeginDrawNativeSurface.Stop" value="BeginDrawNativeSurface" />
				<string id="XamlDrawableSurface.InitializeSurface.Info" value="InitializeSurface" />
				<string id="XamlMultithreadNativeSurfaceOffThread.XamlDrawableSurfaceSetDeviceCommand.Info" value="XamlDrawableSurfaceSetDeviceCommand" />
				<string id="XamlDrawableSurface.EndDrawCommit.Stop" value="EndDrawCommit" />
				<string id="XamlDrawableSurface.EndDrawCommit.Start" value="EndDrawCommit" />
				<string id="XamlMultithreadDrawableSurfaceOffThread.BeginDraw.Stop" value="BeginDraw" />
				<string id="XamlDrawableSurface.BeginDraw.Start" value="BeginDraw" />
				<string id="XamlMultithreadNativeSurfaceUI.OnSurfaceContentsLost.Info" value="OnSurfaceContentsLost" />
				<string id="XamlDrawableSurface.EndDrawDirect2d.Start" value="EndDrawDirect2d" />
				<string id="XamlDrawableSurface.SetDevice.Stop" value="SetDevice" />
				<string id="XamlMultithreadDrawableSurfaceOffThread.EndDraw.Start" value="EndDraw" />
				<string id="XamlDrawableSurface.FlushWork.Start" value="FlushWork" />
				<string id="XamlDrawableSurface.BeginDraw.Stop" value="BeginDraw" />
				<string id="InteractionInstance.OnUpdate.Stop" value="OnUpdate" />
				<string id="InputProcessor.OnInteraction.Start" value="OnInteraction" />
				<string id="InputProcessor.OnInteraction.Stop" value="OnInteraction" />
				<string id="InteractionInstance.OnUpdate.Info" value="OnUpdate" />
				<string id="ScrollingLayer.OnDragOver.Info" value="OnDragOver" />
				<string id="InputProcessor.HandleLayer.Info" value="HandleLayer" />
				<string id="InteractionInstance.OnUpdate.Start" value="OnUpdate" />
				<string id="CommandListRasterizeWork.Draw.Start" value="Draw" />
				<string id="CommandListRasterizeWork.Draw.Stop" value="Draw" />
				<string id="CommandListRasterizeWork.Construct.Info" value="Construct" />
				<string id="CommandListRasterizer.SubmitWork.Info" value="SubmitWork" />
				<string id="VirtualTexture.BeginDrawDirect2dInternalExceededMaxDimension.Info" value="BeginDrawDirect2dInternalExceededMaxDimension" />
				<string id="Compositor.AreAnimationsDisabled.Info" value="AreAnimationsDisabled" />
				<string id="VSISTiler.Resize.Info" value="Resize" />
				<string id="VSISTiler.BeginDraw.Info" value="BeginDraw" />
				<string id="VSISTiler.InvalidateRect.Info" value="InvalidateRect" />
				<string id="CommandListVirtualTexture.BeginDraw.Info" value="BeginDraw" />
				<string id="CommandListVirtualTexture.EndDraw.Info" value="EndDraw" />
				<string id="VSISTiler.Initialize.Info" value="Initialize" />
				<string id="XamlMultithreadNativeSurfaceOffThread.XamlNativeSurfaceSetDeviceCommand.Info" value="XamlNativeSurfaceSetDeviceCommand" />
				<string id="XamlVirtualSurface.Resize.Info" value="Resize" />
				<string id="XamlVirtualSurface.InvalidateRect.Info" value="InvalidateRect" />
				<string id="XamlVirtualSurface.Construct.Info" value="Construct" />
				<string id="Direct2DTexture.XamlMultithreadNativeSurfaceOffThread.Info" value="XamlMultithreadNativeSurfaceOffThread" />
				<string id="XamlMultithreadDrawableSurface.Construct.Info" value="Construct" />
				<string id="XamlSurface.Construct.Info" value="Construct" />
				<string id="XamlMultithreadDrawableSurfaceOffThread.XamlNativeSurfaceSetDeviceCommand.Info" value="XamlNativeSurfaceSetDeviceCommand" />
				<string id="VirtualTexture.VirtualTexture.Start" value="VirtualTexture" />
				<string id="VirtualTexture.VirtualTexture.Stop" value="VirtualTexture" />
				<string id="XamlMultithreadVirtualSurface.Construct.Info" value="Construct" />
				<string id="XamlVirtualizedSurface.Construct.Info" value="Construct" />
				<string id="XamlVirtualSurface.EndDrawInvalidate.Start" value="EndDrawInvalidate" />
				<string id="XamlVirtualSurface.EndDrawInvalidate.Stop" value="EndDrawInvalidate" />
				<string id="XamlVirtualSurface.EndDrawResize.Info" value="EndDrawResize" />
				<string id="Compositor.RenderingDeviceLost.Info" value="RenderingDeviceLost" />
				<string id="VirtualTexture.HitTestSlopInfo.Info" value="HitTestSlopInfo" />
				<string id="ScrollingLayer.BigGridScrollTo.Info" value="BigGridScrollTo" />
				<string id="ScrollingLayer.BigGridAdjustViewportPosition.Info" value="BigGridAdjustViewportPosition" />
				<string id="BitmapAllocator.BitmapMemoryExceededMaxLimit.Info" value="BitmapMemoryExceededMaxLimit" />
				<string id="MemoryHelper.LowResourceModeStatusChange.Info" value="LowResourceModeStatusChange" />
				<string id="ScrollingLayer.ArrangeOverride.Info" value="ArrangeOverride" />
				<string id="ScrollingLayer.ResetPendingScrollTo.Info" value="ResetPendingScrollTo" />
				<string id="ScrollingLayer.ResetPendingZoomTo.Info" value="ResetPendingZoomTo" />
				<string id="BackEndLayer.HandlePropertyChange.Info" value="HandlePropertyChange" />
				<string id="BackEndLayer.SetBottom.Info" value="SetBottom" />
				<string id="BackEndLayer.SetTop.Info" value="SetTop" />
				<string id="ScrollingLayer.AdjustVirtualizedSpace.Info" value="AdjustVirtualizedSpace" />
				<string id="BackEndLayer.SetWidth.Info" value="SetWidth" />
				<string id="BackEndLayer.UpdateHeightProps.Info" value="UpdateHeightProps" />
				<string id="BackEndLayer.SetLeft.Info" value="SetLeft" />
				<string id="ScrollingLayer.ApplyScroll.Info" value="ApplyScroll" />
				<string id="BackEndLayer.AdjustVisibleTile.Info" value="AdjustVisibleTile" />
				<string id="BackEndLayer.SetHeight.Info" value="SetHeight" />
				<string id="BackEndLayer.CreateTile.Info" value="CreateTile" />
				<string id="ScrollingLayer.OnViewChangingNextFinal.Info" value="OnViewChangingNextFinal" />
				<string id="ScrollingLayer.GetVirtualPerimeterOffset.Info" value="GetVirtualPerimeterOffset" />
				<string id="BackEndLayer.DeleteTile.Info" value="DeleteTile" />
				<string id="ScrollingLayer.FireNotifications.Info" value="FireNotifications" />
				<string id="BackEndLayer.SetRight.Info" value="SetRight" />
				<string id="BackEndLayer.EnsureBrushTransform.Info" value="EnsureBrushTransform" />
				<string id="ScrollingLayer.BackEndZoomTo.Info" value="BackEndZoomTo" />
				<string id="BackEndLayer.PropogateVirtualizedRectMismatch.Info" value="PropogateVirtualizedRectMismatch" />
				<string id="BackEndLayer.PropogateVirtualizationChanged.Info" value="PropogateVirtualizationChanged" />
				<string id="BackEndLayer.UpdateWidthProps.Info" value="UpdateWidthProps" />
				<string id="ScrollingLayer.ClientScrollTo.Info" value="ClientScrollTo" />
				<string id="BackEndLayer.HandleVirtualizationChanged.Info" value="HandleVirtualizationChanged" />
				<string id="BackEndLayer.VirtualizeTexture.Info" value="VirtualizeTexture" />
				<string id="BackEndLayer.GetVirtualPerimeter.Info" value="GetVirtualPerimeter" />
				<string id="BackEndLayer.LayoutChanged.Info" value="LayoutChanged" />
				<string id="BackEndLayer.VirtualizationChanged.Info" value="VirtualizationChanged" />
				<string id="BackEndLayer.UpdateBorderLayout.Info" value="UpdateBorderLayout" />
				<string id="BackEndLayer.HitTestLayerBounds.Info" value="HitTestLayerBounds" />
				<string id="BackEndLayer.HitTest.Info" value="HitTest" />
				<string id="BackEndLayer.EvaluateLayerProximity.Info" value="EvaluateLayerProximity" />
				<string id="ScrollingLayerCanvas.QueueZoomTo.Info" value="QueueZoomTo" />
				<string id="ScrollingLayerCanvas.QueueSetCanvasSize.Info" value="QueueSetCanvasSize" />
				<string id="ScrollingLayerCanvas.ArrangeOverride.Info" value="ArrangeOverride" />
				<string id="ScrollingLayerCanvas.QueueScrollTo.Info" value="QueueScrollTo" />
				<string id="ScrollingLayerCanvas.ScrollTo.Info" value="ScrollTo" />
				<string id="ScrollingLayerCanvas.ZoomTo.Info" value="ZoomTo" />
				<string id="ScrollingLayerCanvas.SetCanvasSize.Info" value="SetCanvasSize" />
				<string id="AirSpace.SetDeviceMode.Info" value="SetDeviceMode" />
				<string id="Scene.OnDeviceUpdated.Info" value="OnDeviceUpdated" />
				<string id="AirSpace.ForgetDevice.Info" value="ForgetDevice" />
				<string id="Compositor.SetDeviceMode.Info" value="SetDeviceMode" />
				<string id="DirectXDeviceResources.GetDeviceAccess.Info" value="GetDeviceAccess" />
				<string id="Direct2dDeviceResources.GetDeviceAccess.Info" value="GetDeviceAccess" />
				<string id="Scene.IsDeviceLostNotificationPending.Info" value="IsDeviceLostNotificationPending" />
				<string id="DirectXDeviceResources.DeviceLost.Info" value="DeviceLost" />
				<string id="Scene.DiscardAllDeviceResources.Info" value="DiscardAllDeviceResources" />
				<string id="DirectXDeviceResources.HandleDeviceLoss.Info" value="HandleDeviceLoss" />
				<string id="Scene.ResetAppDevice.Info" value="ResetAppDevice" />
				<string id="Direct2dDeviceResources.HandleDeviceLoss.Info" value="HandleDeviceLoss" />
				<string id="ScrollingLayer.ViewportPositionChangingCurrent.Info" value="ViewportPositionChangingCurrent" />
				<string id="ScrollingLayer.SetCanvasSize.Start" value="SetCanvasSize" />
				<string id="ScrollingLayer.Arrange.Stop" value="Arrange" />
				<string id="ScrollingLayer.MaxViewportDestination.Info" value="MaxViewportDestination" />
				<string id="ScrollingLayer.OnViewChangingNext.Info" value="OnViewChangingNext" />
				<string id="ScrollingLayer.SetCanvasSize.Stop" value="SetCanvasSize" />
				<string id="ScrollingLayer.ViewportPositionChangingFinal.Info" value="ViewportPositionChangingFinal" />
				<string id="ScrollingLayer.ArrangeAbort.Info" value="ArrangeAbort" />
				<string id="ScrollingLayer.Arrange.Start" value="Arrange" />
				<string id="ScrollingLayerCanvas.ChangeView.Info" value="ChangeView" />
				<string id="ScrollingLayer.UpdateScrollViewportCommandImm.Info" value="UpdateScrollViewportCommandImm" />
				<string id="AirSpace.LocalBlocklist.Info" value="LocalBlocklistInfo" />
				<string id="AirSpace.LocalBlocklist.DriverUpdated" value="LocalBlocklistDriverUpdated" />
				<string id="AirSpace.LocalBlocklist.GraphicsHwCrashUsingSw" value="GraphicsHwCrashUsingSw" />
				<string id="Compositor.AnimationsDisabledReason.Info" value="AnimationDisabledReason" />
				<string id="ScrollingLayer.BackEndScrollToRealUnit.Info" value="BackEndScrollToRealUnit" />
				<string id="ScrollingLayer.CurrentZoomFactorChanged.Info" value="CurrentZoomFactorChanged" />
				<string id="ScrollingLayer.FinalZoomFactorChanged.Info" value="FinalZoomFactorChanged" />
				<string id="ScrollingLayer.CurrentViewportChanged.Info" value="CurrentViewportChanged" />
				<string id="ScrollingLayer.FinalViewportChanged.Info" value="FinalViewportChanged" />
				<string id="ScrollingLayer.SetVirtualPerimeter.Info" value="SetVirtualPerimeter" />
				<string id="ScrollingLayer.ArrangePendingScroll.Info" value="ArrangePendingScroll" />
				<string id="ScrollingLayer.FinalPlatformViewportOffsetChanged.Info" value="FinalPlatformViewportOffsetChanged" />
				<string id="CommandListVirtualTextureWinComp.OnAppResuming.Info" value="OnAppResuming" />
				<string id="LayerTileManager.ResetPrefetchScope.Info" value="ResetPrefetchScope" />
				<string id="ScrollingLayerWinComp.SetupScrollBars.Info" value="SetupScrollBars" />
				<string id="LayerCommandListVirtualTextureWinComp.Destroy.Info" value="Destroy" />
				<string id="SurfaceLayerBitmapTextureWinComp.SetTile.Info" value="SetTile" />
				<string id="LayerCommandListVirtualTextureWinComp.Create.Info" value="Create" />
				<string id="LayerCommandListVirtualTextureWinComp.LayoutChangedInternal.Info" value="LayoutChangedInternal" />
				<string id="CommandListVirtualTextureWinComp.Destroy.Info" value="Destroy" />
				<string id="LayerCommandListVirtualTextureWinComp.ResetScrollingLayerParentInternal.Info" value="ResetScrollingLayerParentInternal" />
				<string id="SurfaceLayerBitmapTextureWinComp.CompositionSurfaceChanged.Info" value="CompositionSurfaceChanged" />
				<string id="CommandListVirtualTextureWinComp.Create.Info" value="Create" />
				<string id="BitmapTextureWinComp.SetStretchMode.Info" value="SetStretchMode" />
				<string id="VirtualTextureWinComp.Create.Info" value="Create" />
				<string id="VirtualTextureWinComp.Resize.Info" value="Resize" />
				<string id="BitmapTextureWinComp.Create.Info" value="Create" />
				<string id="VirtualTextureWinComp.Destroy.Info" value="Destroy" />
				<string id="ScrollingLayerWinComp.ScrollBarIndicatorMode.Info" value="ScrollBarIndicatorMode" />
				<string id="VirtualTextureWinComp.SetPrefetchSize.Info" value="SetPrefetchSize" />
				<string id="BitmapTextureWinComp.Destroy.Info" value="Destroy" />
				<string id="LayerVirtualTextureWinComp.Create.Info" value="Create" />
				<string id="SurfaceLayerBitmapTextureWinComp.OnLayerSizeChanged.Info" value="OnLayerSizeChanged" />
				<string id="SurfaceLayerBitmapTextureWinComp.ApplyStretchMode.Info" value="ApplyStretchMode" />
				<string id="BitmapTextureWinComp.CreateTile.Info" value="CreateTile" />
				<string id="LayerVirtualTextureWinComp.Destroy.Info" value="Destroy" />
				<string id="LayerCommandListVirtualTextureWinComp.SetScrollingLayerParentInternal.Info" value="SetScrollingLayerParentInternal" />
				<string id="VirtualTextureWinComp.OnAppSuspending.Info" value="OnAppSuspending" />
				<string id="BitmapTextureWinComp.OnAppResuming.Info" value="OnAppResuming" />
				<string id="VirtualTextureWinComp.OnAppResuming.Info" value="OnAppResuming" />
				<string id="BitmapTextureWinComp.OnAppSuspending.Info" value="OnAppSuspending" />
				<string id="SurfaceLayerBitmapTextureWinComp.DrawForTiling.Info" value="DrawForTiling" />
				<string id="SurfaceLayerBitmapTextureWinComp.Destroy.Info" value="Destroy" />
				<string id="SurfaceLayerBitmapTextureWinComp.Create.Info" value="Create" />
				<string id="CommandListVirtualTextureWinComp.OnAppSuspending.Info" value="OnAppSuspending" />
				<string id="LayerTileManager.SetPrefetchScope.Info" value="SetPrefetchScope" />
				<string id="VirtualTextureWinComp.InvalidateRect.Info" value="InvalidateRect" />
				<string id="Direct2DTextureWinComp.BeginDraw.Stop" value="BeginDraw" />
				<string id="SurfaceLayerSwapChainTextureWinComp.Create.Info" value="Create" />
				<string id="SwapChainTextureWinComp.DeviceLoss.Info" value="DeviceLoss" />
				<string id="WindowCompositor.SetRenderingDeviceFailure.Info" value="SetRenderingDeviceFailure" />
				<string id="Direct2DTextureWinComp.HandleDrawHr.Info" value="HandleDrawHr" />
				<string id="WindowCompositor.Create.Info" value="Create" />
				<string id="Direct2DTextureWinComp.OnSuspend.Info" value="OnSuspend" />
				<string id="Direct2DTextureWinComp.EndDraw.Start" value="EndDraw" />
				<string id="WindowCompositor.Destroy.Info" value="Destroy" />
				<string id="VirtualTextureWinComp.HandleDrawHr.Info" value="HandleDrawHr" />
				<string id="Direct2DTextureWinComp.SetStretchMode.Info" value="SetStretchMode" />
				<string id="Direct2DTextureWinComp.EnsureTile.Info" value="EnsureTile" />
				<string id="VirtualTextureWinComp.OnResume.Info" value="OnResume" />
				<string id="SwapChainTextureWinComp.OnResume.Info" value="OnResume" />
				<string id="SurfaceLayerSwapChainTextureWinComp.Destroy.Info" value="Destroy" />
				<string id="Direct2DTextureWinComp.DeviceLoss.Info" value="DeviceLoss" />
				<string id="VirtualTextureWinComp.CreateFrontEnd.Info" value="CreateFrontEnd" />
				<string id="SwapChainTextureWinComp.Create.Info" value="Create" />
				<string id="WindowCompositor.EnsureWindowCompositionGraphicsDevice.Info" value="EnsureWindowCompositionGraphicsDevice" />
				<string id="VirtualTextureWinComp.DestroyFrontEnd.Info" value="DestroyFrontEnd" />
				<string id="WindowCompositionGraphicsDevice.SetRenderingDevice.Info" value="SetRenderingDevice" />
				<string id="Direct2DTextureWinComp.EndDraw.Stop" value="EndDraw" />
				<string id="SwapChainTextureWinComp.Destroy.Info" value="Destroy" />
				<string id="Direct2DTextureWinComp.BeginDraw.Start" value="BeginDraw" />
				<string id="SurfaceLayerSwapChainTextureWinComp.CompositionSurfaceChanged.Info" value="CompositionSurfaceChanged" />
				<string id="Direct2DTextureWinComp.Resize.Info" value="Resize" />
				<string id="VirtualTextureWinComp.DeviceLoss.Info" value="DeviceLoss" />
				<string id="SwapChainTextureWinComp.OnAppSuspending.Info" value="OnAppSuspending" />
				<string id="VirtualTextureWinComp.OnSuspend.Info" value="OnSuspend" />
				<string id="SwapChainTextureWinComp.HandleDeviceHr.Info" value="HandleDeviceHr" />
				<string id="Direct2DTextureWinComp.OnResume.Info" value="OnResume" />
				<string id="SwapChainTextureWinComp.DestroyFrontEnd.Info" value="DestroyFrontEnd" />
				<string id="SwapChainTextureWinComp.OnSuspend.Info" value="OnSuspend" />
				<string id="Direct2DTextureWinComp.BeginDrawNullRenderTarget.Info" value="BeginDrawNullRenderTarget" />
				<string id="SwapChainTextureWinComp.CreateFrontEnd.Info" value="CreateFrontEnd" />
				<string id="ScrollingLayerWinComp.OnPointerWheelChanged.Info" value="OnPointerWheelChanged" />
				<string id="ScrollingLayerWinComp.TryRedirectForManipulation.Info" value="TryRedirectForManipulation" />
				<string id="LayerWinComp.UpdateBorderLayout.Info" value="UpdateBorderLayout" />
				<string id="ScrollingLayerWinComp.SetupInteractionTracker.Info" value="SetupInteractionTracker" />
				<string id="ScrollingLayer.ClearZoomSnapPoints.Info" value="ClearZoomSnapPoints" />
				<string id="ScrollingLayer.SetRegularSnapPoints.Info" value="SetRegularSnapPoints" />
				<string id="ScrollingLayer.SetSnapPointsType.Info" value="SetSnapPointsType" />
				<string id="ScrollingLayer.SetIrregularSnapPoints.Info" value="SetIrregularSnapPoints" />
				<string id="ScrollingLayer.AddZoomSnapPoint.Info" value="AddZoomSnapPoint" />
				<string id="TileWinComp.CreateSurfaceFailure.Info" value="CreateSurfaceFailure" />
				<string id="TileWinComp.EndDrawFailure.Info" value="EndDrawFailure" />
				<string id="Compositor.WinCompIsEnabled.Info" value="WinCompIsEnabled" />
				<string id="SwapChainTextureWinComp.BeginDrawAppSuspended.Info" value="BeginDrawAppSuspended" />
				<string id="SwapChainTextureWinComp.BeginDrawEnsureResources.Info" value="BeginDrawEnsureResources" />
				<string id="SwapChainTextureWinComp.BeginDrawWrongThread.Info" value="BeginDrawWrongThread" />
				<string id="SwapChainTextureWinComp.BeginDrawNonRenderTexture.Info" value="BeginDrawNonRenderTexture" />
				<string id="SwapChainTextureWinComp.BeginDrawNestedDraw.Info" value="BeginDrawNestedDraw" />
				<string id="VirtualTextureBaseWinComp.OnAppResuming.Info" value="OnAppResuming" />
				<string id="VirtualTextureBaseWinComp.OnAppSuspending.Info" value="OnAppSuspending" />
				<string id="VirtualTextureBaseWinComp.InvalidateRect.Info" value="InvalidateRect" />
				<string id="VirtualTextureBaseWinComp.Resize.Info" value="Resize" />
				<string id="VirtualTextureBaseWinComp.SetPrefetchSize.Info" value="SetPrefetchSize" />
				<string id="ScrollingLayerWinComp.ChainingSupportChanged.Info" value="ChainingSupportChanged" />
				<string id="ScrollingLayerWinComp.ValuesChanged.Start" value="ValuesChanged" />
				<string id="ScrollingLayerWinComp.RequestIgnored.Info" value="RequestIgnored" />
				<string id="ScrollingLayerWinComp.InertiaStateEntered.Info" value="InertiaStateEntered" />
				<string id="ScrollingLayerWinComp.ApplyScroll.Info" value="ApplyScroll" />
				<string id="ScrollingLayerWinComp.ValuesChangedWorkaround.Info" value="ValuesChangedWorkaround" />
				<string id="ScrollingLayerWinComp.ValuesChanged.Stop" value="ValuesChanged" />
				<string id="ScrollingLayerWinComp.Rejigger.Stop" value="Rejigger" />
				<string id="ScrollingLayerWinComp.InteractingStateEntered.Info" value="InteractingStateEntered" />
				<string id="ScrollingLayerWinComp.Rejigger.Start" value="Rejigger" />
				<string id="ScrollingLayerWinComp.UpdateViewportPosition.Info" value="UpdateViewportPosition" />
				<string id="ScrollingLayerWinComp.IdleStateEntered.Info" value="IdleStateEntered" />
				<string id="ScrollingLayerWinComp.CustomAnimationStateEntered.Info" value="CustomAnimationStateEntered" />
				<string id="ScrollingLayer.UpdateMinMaxPosition.Info" value="UpdateMinMaxPosition" />
				<string id="VirtualTexture.FrontEndWin32BeginDrawGdi.Info" value="FrontEndWin32BeginDrawGdi" />
				<string id="GdiTexture.BeginDrawNullHDC.Info" value="BeginDrawNullHDC" />
				<string id="VirtualTexture.BeginDrawNullHDC.Info" value="BeginDrawNullHDC" />
				<string id="VirtualTexture.BeginDrawNullRenderTarget.Info" value="BeginDrawNullRenderTarget" />
				<string id="ArcTextureApple.BeginDrawNullRenderTarget.Info" value="BeginDrawNullRenderTarget" />
				<string id="TileWinComp.CreateCompositionSurface.Info" value="CreateCompositionSurface" />
				<string id="LayerHostWin32.SetDirectManipulationActive.Info" value="SetDirectManipulationActive" />
				<string id="ScrollingLayerWinComp.ValuesChangedRequestId.Info" value="ValuesChangedRequestId" />
				<string id="BackEndLayer.PropogatevirtualPerimeterMismatch.Info" value="PropogatevirtualPerimeterMismatch" />
				<string id="BackEndLayer.PropogateVirtualizedRectMismatchInfo.Info" value="PropogateVirtualizedRectMismatchInfo" />
				<string id="ScrollingLayerWinComp.TryUpdatePositionWithAnimation.Info" value="TryUpdatePositionWithAnimation" />
				<string id="ScrollingLayerWinComp.TryUpdateScaleWithAnimation.Info" value="TryUpdateScaleWithAnimation" />
				<string id="ScrollingLayerWinComp.TryUpdatePositionWithoutClamping.Info" value="TryUpdatePositionWithoutClamping" />
				<string id="ScrollingLayerWinComp.TryUpdateScale.Info" value="TryUpdateScale" />
				<string id="ScrollingLayerWinComp.UpdatePlatformCanvasSize.Info" value="UpdatePlatformCanvasSize" />
				<string id="ScrollingLayerWinComp.ApplyScrollOffsetsAdjusted.Info" value="ApplyScrollOffsetsAdjusted" />
				<string id="TileWinComp.SurfaceNotCoveredByInitialDraw.Info" value="SurfaceNotCoveredByInitialDraw" />
				<string id="BitmapTexture.InvalidSetStretchModeUsage" value="InvalidSetStretchModeUsage" />
				<string id="BitmapTexture.InvalidCopyBitmapTextureUsage" value="InvalidCopyBitmapTextureUsage" />
				<string id="Channel.ChannelActivity.Info" value="ChannelActivity" />
				<string id="Layer.ApplyIntermediateVirtualTextureUntilContentReady" value="ApplyIntermediateVirtualTextureUntilContentReady" />
				<string id="Channel.ChannelActivityExtended.Info" value="ChannelActivity" />
				<string id="WinCompAnimationScheduler.ScrollAnimation.Info" value="ScrollAnimation" />
				<string id="Exception.AbnormalStateEntered.Info" value="AbnormalStateEntered" />
				<string id="InputProcessing.PointerDown.Info" value="PointerDownForPointerID" />
				<string id="InputProcessing.PointerUp.Info" value="PointerUPForPointerID" />
				<string id="InputProcessing.SetContact.Info" value="SetContactForPointerID" />
				<string id="InputProcessing.ActivateScrolling.Info" value="ActivateScrollingForPointerID" />
				<string id="InputProcessing.TryRedirectInputForManipulation.Info" value="TryRedirectInputForManipulationForPointerID" />
				<string id="InputProcessing.CancelInteractionTracker.Info" value="CancelInteractionTracker" />
				<string id="InputProcessing.ResumeInteractionTracker.Info" value="ResumeInteractionTracker" />
				<string id="TileWinComp.VirtualTextureOptimizerTileLog.Info" value="VirtualTextureOptimizerTileLog" />
				<string id="Channel.WinCompVisualCaptureWait.Info" value="tidWinCompVisualCaptureWait" />
				<string id="Channel.WinCompBlockingCommandWait.Info" value="tidWinCompBlockingCommandWait" />
			</stringTable>
		</resources>
	</localization>
</instrumentationManifest>

